/**
 * 自定义模块前端工具
 */
(function () {


    let URLS = {
        "config": {
            "get": "/mdiy/config/get.do",
            formURL: {
                update: {
                    "url": "/mdiy/config/data/update.do",
                    "params": {}
                },
                save: {
                    "url": "/mdiy/config/data/update.do",
                    "params": {}
                },
                get: {
                    "url": "/mdiy/config/data/get.do",
                    "params": {}
                }
            },

        },
        "form": {
            "get": "/mdiy/form/get.do",
            formURL: {
                update: {
                    "url": "/mdiy/form/data/update.do",
                    "params": {}
                },
                save: {
                    "url": "/mdiy/form/data/save.do",
                    "params": {}
                },
                get: {
                    "url": "/mdiy/form/data/getData.do",
                    "params": {}
                }
            },
        },
        "model": {
            "get": "/mdiy/model/get.do",
            formURL: {
                update: {
                    "url": "/mdiy/model/data/update.do",
                    "params": {}
                },
                save: {
                    "url": "/mdiy/model/data/save.do",
                    "params": {}
                },
                get: {
                    "url": "/mdiy/model/data.do",
                    "params": {}
                }
            },
        }
    };

    /**
     * 获取自定义配置
     * @param configName:配置名称
     * @paramk key:配置的key值(可选)，key == null 可以获取所有的配置
     * @param isSystem true 后台调用会拼接后台地址 false前台调用
     */
    function config(configName, key,isSystem) {

        var data = {configName: configName};

        if(key != null) {
            data.key = key;
        }

        if(isSystem) {
            return ms.http.get(ms.manager + "/mdiy/config/data/getMap.do",data);
        } else {
            return ms.http.get(ms.base + "/mdiy/config/get.do",data);
        }

    }



    var dict = {
        /**
         *  获取所有字典类型的数组集合
         * @param dictType 字典类型 支持多个类型用英文逗号隔开
         * @param isChild 子业务类型 可选
         */
        list: function(dictType, isChild) {
            var _dict = {
                dictType: dictType,
                isChild: isChild,
            }
            return ms.http.get(ms.base + '/mdiy/dict/list.do', _dict);
        },
        /**
         * 根据字典 value 获取对应的 label
         * @param dictList 字典列表
         * @param value 值
         * @returns {string|string|[{message: string, required: boolean}]|*}
         */
        getLabel: function(dictList, value) {
            var data = dictList.find(function (v) {
                return v.dictValue == value;
            });

            if (data) {
                return data.dictLabel;
            }
            return "";
        },
        /**
         * 根据字典 label 获取对应的 value
         * @param dictList 字典列表
         * @param label 值
         * @returns {string|string|[{message: string, required: boolean}]|*}
         */
        getValue: function(dictList, label) {
            var data = dictList.find(function (v) {
                return v.dictLabel == label;
            });

            if (data) {
                return data.dictValue;
            }
            return "";
        }

    }


    var model = {

        /**
         * 模型地址资源配置
         */

        /**
         * 配置模型
         * @param renderDomId 绑定的domid,表单会显示在dom里面
         * @param model 模型对象 示例：业务调用{modelName:模型名称}，自动业务使用{id:模型编号}
         * @param params 请求参数 示例：{参数名称:值}
         * @param isSystem true 后台调用会拼接后台地址 false前台调用
         * @returns {Promise<custom_model>}
         */
        config:  function(renderDomId, model, params, isSystem) {

            URLS.config.formURL.get.params = params;
            var urlStrs = JSON.stringify(URLS.config.formURL);
            return this.render(renderDomId, model, JSON.parse(urlStrs), URLS["config"].get, isSystem);
        },

        /**
         * 业务表单模型
         * @param renderDomId 绑定的domid,表单会显示在dom里面
         * @param model 模型对象 示例：业务调用{modelName:模型名称}，自动业务使用{id:模型编号}
         * @param params 请求参数 示例：{参数名称:值}
         * @param isSystem true 后台调用会拼接后台地址 false前台调用
         * @returns {Promise<custom_model>}
         */
        form:  function(renderDomId, model, params, isSystem) {
            URLS.form.formURL.get.params = params;
            var urlStrs = JSON.stringify(URLS.form.formURL);

            return this.render(renderDomId, model, JSON.parse(urlStrs), URLS["form"].get, isSystem);
        },

        /**
         * 扩展业务模型
         * @param renderDomId 绑定的domid,表单会显示在dom里面
         * @param model 模型对象 示例：业务调用方式{modelName:模型名称}如配置的使用，自动业务使用{id:模型编号},如内容模型
         * @param params 请求参数 示例：{参数名称:值}
         * @param isSystem true 后台调用会拼接后台地址 false前台调用
         * @returns {Promise<custom_model>}
         */
        extend: function(renderDomId, model, params, isSystem) {

            URLS.model.formURL.get.params = params;
            var urlStrs = JSON.stringify(URLS.model.formURL);

            return this.render(renderDomId, model,JSON.parse(urlStrs) , URLS["model"].get, isSystem);
        },

        /**
         * iframe方式渲染自定义模型对象
         * @param renderDomId 绑定的domid,表单会显示在dom里面
         * @param model 模型对象 示例：业务调用{modelName:模型名称}，自动业务使用{id:模型编号}
         * @param url 模型获取地址
         * @param isSystem true 后台调用会拼接后台地址 false前台调用
         * @returns {Promise<custom_model>} 返回model对象
         */
        render:  function(renderDomId, model, formUrls, url, isSystem) {
            // if(model.modelName!=undefined || model.modelId!=undefined){
            //     return null;
            // }
            //查模型

            if (isSystem) {
                url = ms.manager + url;
                formUrls.update.url = ms.manager + formUrls.update.url;
                formUrls.save.url = ms.manager + formUrls.save.url;
                formUrls.get.url = ms.manager + formUrls.get.url;
            } else {
                url = ms.base + url;
                formUrls.update.url = ms.base + formUrls.update.url;
                formUrls.save.url = ms.base + formUrls.save.url;
                formUrls.get.url = ms.base + formUrls.get.url;
            }
            var modelId = 0;
            var modelName = "";

            return new Promise(function(resolve,reject) {

                ms.http.get(url, model).then(function (res) {
                    if (res.result && res.data) {
                        // 获取模型
                        modelId = res.data.id;
                        modelName = res.data.modelName;

                        var data = JSON.parse(res.data.modelJson);
                        var model = document.getElementById(renderDomId);
                        var iframe = document.createElement('iframe');
                        if( model.getElementsByTagName("iframe")[0]) {
                            model.removeChild( model.getElementsByTagName("iframe")[0])
                        }
                        iframe.setAttribute("id", "___custom-model");
                        iframe.setAttribute("border", "0");
                        iframe.setAttribute("frameborder", "no");
                        iframe.setAttribute("style", "height:calc(100vh - 80px)");

                        iframe.width="100%"
                        model.appendChild(iframe);

                        window._callbackCustomModel = function (modelObj) {
                            resolve(modelObj);
                        }
                        var vueDataJson = {
                            data: {
                                modelName: modelName,
                                modelId: modelId,
                                formURL: formUrls
                            }
                        }

                        var _new = ";ms.base='"+ms.base+"' ; ms.manager='"+ms.manager+"' ; var _custom_model = new custom_model("+JSON.stringify(vueDataJson)+");window.parent._callbackCustomModel(_custom_model);";
                        var htmlStr = "<script src=\'"+ms.base+"/static/plugins/axios/0.18.0/axios.min.js\'><\/script>";
                        htmlStr += "<link rel=\'stylesheet\' href=\'"+ms.base+"/static/css/app.css'\/>";
                        htmlStr += "<script type=\'text/javascript\' src=\'"+ms.base+"/static/plugins/qs/6.6.0/qs.min.js\'><\/script>";
                        htmlStr += "<script type=\'text/javascript\' src=\'"+ms.base+"/static/plugins/vue/2.6.9/vue.min.js\'><\/script>";
                        htmlStr += "<script src=\'"+ms.base+"/static/plugins/element-ui/2.15.8/index.min.js\'><\/script>"
                        htmlStr += "<script src=\'"+ms.base+"/static/plugins/ms/2.0/ms.umd.js\'><\/script>";
                        htmlStr += "<script src=\'"+ms.base+"/static/plugins/ms/2.0/ms-el-form.umd.js\'><\/script>";
                        htmlStr += "<link rel=\'stylesheet\' href=\'"+ms.base+"/static/plugins/element-ui/2.15.8/theme-chalk/index.min.css\'>";
                        htmlStr +="<div id='custom-model'>"+data.html.replace("<el-form ","<el-form οnsubmit=\"return false;\" ")+"</div>";
                        htmlStr +="<script>"+data.script+_new+"<\/script>";
                        iframe.contentWindow.document.write("<body style='background-color: #fff;overflow-y: scroll; height: 100% '>"+htmlStr+"</body>");
                    }
                });
            })
        },
        /**
         * 获取相关联自定义模型对象
         * @returns 自定义模型对象
         */
        modelForm: function () {
            return document.getElementById("___custom-model").contentWindow._custom_model;
        }
    }

    var mdiy = {
        dict: dict,
        model: model,
        config: config
    }


    if (typeof ms != "object") {
        window.ms = {};
    }
    window.ms.mdiy = mdiy;
    window.ms.debug = false
}());
