/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.store.action;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.store.biz.IShareBiz;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u540e\u7aef-\u5206\u4eab\u8fd8\u539f\u76ae\u80a4\u63a5\u53e3"})
@Controller(value="/cmsShareAction")
@RequestMapping(value={"/${ms.manager.path}/store/share"})
public class ShareAction
extends BaseAction {
    @Autowired
    private IShareBiz shareBiz;

    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"store:share:view"})
    public String index() {
        return "/store-client/index";
    }

    @ApiOperation(value="\u5bfc\u51fa\u5f53\u524d\u6a21\u677f\u53ca\u76f8\u5173\u8d44\u6e90\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"exp"})
    @RequiresPermissions(value={"store:share:exp"})
    @ResponseBody
    public ResponseEntity exp() throws IOException {
        String tmpDirPath = FileUtil.getTmpDirPath();
        String filePath = this.shareBiz.backup(tmpDirPath + File.separator + BasicUtil.getApp().getAppStyle());
        File backZip = FileUtil.file((String)filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("fileName", BasicUtil.getApp().getAppStyle() + ".zip");
        headers.setContentLength(backZip.length());
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        byte[] fileBytes = FileUtils.readFileToByteArray((File)backZip);
        FileUtil.del((File)backZip);
        return new ResponseEntity((Object)fileBytes, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @ApiOperation(value="\u89e3\u538b\u6a21\u677f")
    @LogAnn(title="\u89e3\u538b\u6a21\u677f", businessType=BusinessTypeEnum.OTHER)
    @PostMapping(value={"imp"})
    @RequiresPermissions(value={"store:share:imp"})
    @ResponseBody
    public ResultData imp() throws IOException, BusinessException {
        String targetDir;
        String rootPath = BasicUtil.getRealPath((String)"/");
        String template = MSProperties.upload.template;
        File uploadPath = new File(BasicUtil.getRealPath((String)MSProperties.upload.path));
        if (!FileUtil.exist((File)uploadPath)) {
            FileUtil.mkdir((File)uploadPath);
        }
        if ((targetDir = BasicUtil.getString((String)"targetDir")) != null && (targetDir.contains("../") || targetDir.contains("..\\"))) {
            ResultData.build().error();
        }
        File zipFile = new File(BasicUtil.getRealTemplatePath((String)targetDir));
        ZipUtil.unzip((String)zipFile.getPath(), (String)BasicUtil.getRealPath((String)FileUtil.getPrefix((File)zipFile)), (Charset)Charset.forName("UTF-8"));
        File tmplZipFile = new File(BasicUtil.getRealPath((String)FileUtil.getPrefix((File)zipFile)));
        File tmplFile = tmplZipFile.listFiles(file -> !file.getName().equals("html") && !file.getName().equals("data"))[0];
        File dataFile = tmplZipFile.listFiles(file -> file.getName().equals("data"))[0];
        String tmplPath = tmplFile.getPath();
        String tmplName = tmplFile.getName();
        String dataFilePath = dataFile.getPath();
        FileUtil.copy((String)tmplPath, (String)(rootPath + File.separator + template + File.separator + BasicUtil.getApp().getId()), (boolean)true);
        FileUtil.copy((String)dataFilePath, (String)(rootPath + File.separator + template + File.separator + BasicUtil.getApp().getId()), (boolean)true);
        FileUtil.del((String)BasicUtil.getRealPath((String)FileUtil.getPrefix((File)zipFile)));
        boolean shareTmpl = false;
        List files = FileUtil.loopFiles((String)zipFile.getParent());
        List deniedList = Arrays.stream(MSProperties.upload.denied.split(",")).map(String::toLowerCase).collect(Collectors.toList());
        for (File file2 : files) {
            FileInputStream fileInputStream = new FileInputStream(file2);
            String fileType = FileTypeUtil.getType((File)file2).toLowerCase();
            if (deniedList.contains(fileType)) {
                IOUtils.closeQuietly((Closeable)fileInputStream);
                FileUtil.del((String)zipFile.getParent());
                throw new RuntimeException(StrUtil.format((CharSequence)"\u538b\u7f29\u5305\u5185\u6587\u4ef6{}\u7684\u7c7b\u578b{}\u7981\u6b62\u4e0a\u4f20", (Object[])new Object[]{file2.getName(), fileType}));
            }
            if ("CMS_CATEGORY.json".equals(file2.getName()) && "data".equals(FileNameUtil.getName((String)file2.getParent()))) {
                shareTmpl = true;
            }
            IOUtils.closeQuietly((Closeable)fileInputStream);
        }
        if (shareTmpl) {
            this.shareBiz.tmplUnZip(tmplName);
        }
        FileUtil.del((File)zipFile);
        return ResultData.build().success();
    }
}

