/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.store.biz.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.MapCacheUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.store.biz.IShareBiz;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="shareBizImpl")
public class ShareBizImpl
implements IShareBiz {
    @Autowired
    private IModelBiz modelBiz;

    @Override
    @Transactional
    public String backup(String backDir) {
        String upload = MSProperties.upload.path;
        String template = MSProperties.upload.template;
        AppEntity app = BasicUtil.getApp();
        String appId = app.getId();
        String rootPath = BasicUtil.getRealPath((String)"/");
        if (!new File(backDir).isAbsolute()) {
            backDir = rootPath + File.separator + backDir;
        }
        String tmplBackDir = backDir;
        File tmplFile = new File(rootPath + template + File.separator + appId + File.separator + app.getAppStyle());
        if (!tmplFile.exists()) {
            throw new BusinessException("\u5e94\u7528\u8bbe\u7f6e\u7ed1\u5b9a\u6a21\u677f\u4e0d\u5b58\u5728\uff01\u8bf7\u5728\u5e94\u7528\u8bbe\u7f6e\u5904\u5237\u65b0\u7f13\u5b58");
        }
        FileUtil.copy((String)(rootPath + template + File.separator + appId + File.separator + app.getAppStyle()), (String)tmplBackDir, (boolean)true);
        FileUtil.copy((String)(rootPath + upload), (String)(tmplBackDir + "/data"), (boolean)true);
        List contentList = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CONTENT");
        String contents = JSONUtil.toJsonStr((Object)contentList);
        contents = contents.replaceAll("pboot", "xxx");
        contents = contents.replaceAll("Pboot", "xxx");
        List categoryList = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CATEGORY");
        String categories = JSONUtil.toJsonStr((Object)categoryList);
        List appMap = (List)this.modelBiz.excuteSql("SELECT APP_NAME,APP_LOGO,APP_KEYWORD,APP_COPYRIGHT,APP_STYLE,APP_DESCRIPTION FROM APP");
        String appInfo = JSONUtil.toJsonStr(appMap.get(0));
        FileUtil.writeString((String)appInfo, (String)(tmplBackDir + "/data/APP.json"), (Charset)StandardCharsets.UTF_8);
        FileUtil.writeString((String)contents, (String)(tmplBackDir + "/data/CMS_CONTENT.json"), (Charset)StandardCharsets.UTF_8);
        if (categories != null) {
            categories = categories.replaceAll("pboot", "xxx");
            categories = categories.replaceAll("Pboot", "xxx");
            FileUtil.writeString((String)categories, (String)(tmplBackDir + "/data/CMS_CATEGORY.json"), (Charset)StandardCharsets.UTF_8);
            List categoryModelMap = categoryList.stream().filter(itemMap -> !Objects.isNull(itemMap.get("MDIY_MODEL_ID")) && StringUtils.isNotBlank((CharSequence)itemMap.get("MDIY_MODEL_ID").toString())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(categoryModelMap)) {
                List modelIds = categoryModelMap.stream().map(mdiyModel -> mdiyModel.get("MDIY_MODEL_ID").toString()).collect(Collectors.toList());
                List backModelEntities = this.modelBiz.listByIds(modelIds);
                backModelEntities.forEach(backModel -> {
                    Object modelData = this.modelBiz.excuteSql("SELECT * FROM " + backModel.getModelTableName());
                    String modelDataJson = JSONUtil.toJsonStr((Object)modelData);
                    String modelJson = backModel.getModelJson();
                    ModelJsonBean modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelJson, ModelJsonBean.class);
                    modelJsonBean.setTitle(backModel.getModelName());
                    modelJson = JSONUtil.toJsonStr((Object)modelJsonBean);
                    FileUtil.writeString((String)modelDataJson, (String)(tmplBackDir + "/data/" + backModel.getModelTableName() + ".json"), (Charset)StandardCharsets.UTF_8);
                    FileUtil.writeString((String)modelJson, (String)(tmplBackDir + "/data/MODEL_JSON_" + backModel.getModelTableName() + ".json"), (Charset)StandardCharsets.UTF_8);
                    FileUtil.appendUtf8String((String)backModel.getId(), (String)(tmplBackDir + "/data/MODEL_JSON_" + backModel.getModelTableName() + ".json"));
                });
            }
        }
        String html = MSProperties.diy.htmlDir;
        String htmlFilePath = rootPath + html;
        this.htmlReplace(htmlFilePath, template, appId);
        FileUtil.copy((String)(rootPath + html + File.separator + app.getAppDir()), (String)(tmplBackDir + File.separator + "html"), (boolean)true);
        File zipFile = ZipUtil.zip((String)tmplBackDir);
        FileUtil.del((String)tmplBackDir);
        return zipFile.getPath();
    }

    @Override
    @Transactional
    public void tmplUnZip(String tmplName) {
        this.delData();
        this.importData(tmplName);
    }

    private void importData(String tmplName) {
        File[] mdiyModels;
        File[] mdiyModelJsons;
        File[] files;
        String template = MSProperties.upload.template;
        String upload = MSProperties.upload.path;
        String rootPath = BasicUtil.getRealPath((String)"/");
        AppEntity app = BasicUtil.getApp();
        String tmplDir = rootPath + File.separator + template + File.separator + app.getId();
        String categoryJSON = FileUtil.readString((String)(tmplDir + "/data/CMS_CATEGORY.json"), (Charset)StandardCharsets.UTF_8);
        List categories = JSONUtil.toList((String)categoryJSON, Map.class);
        categories.forEach(category -> {
            category.put("create_date", DateTime.of((long)((Long)category.get("create_date"))));
            category.put("update_date", DateTime.of((long)((Long)category.get("update_date"))));
            if (Objects.isNull(category.get("category_display"))) {
                category.put("category_display", "enable");
            }
            this.modelBiz.insertBySQL("CMS_CATEGORY", category);
        });
        String contentJSON = FileUtil.readString((String)(tmplDir + "/data/CMS_CONTENT.json"), (Charset)StandardCharsets.UTF_8);
        List contents = JSONUtil.toList((String)contentJSON, Map.class);
        for (int i = 0; i < contents.size(); ++i) {
            File[] content = (File[])contents.get(i);
            content.put("content_datetime", DateTime.of((long)(System.currentTimeMillis() + (long)i * 1000L)));
            content.put("update_date", new Date());
            content.put("create_date", new Date());
            this.modelBiz.insertBySQL("CMS_CONTENT", (Map)content);
        }
        for (File file : files = new File(tmplDir + "/data/upload").listFiles()) {
            if ("appLogo".equals(file.getName()) || "cms".equals(file.getName())) {
                FileUtil.copy((String)file.getPath(), (String)BasicUtil.getRealPath((String)(upload + File.separator + app.getId())), (boolean)true);
                continue;
            }
            FileUtil.copy((String)file.getPath(), (String)BasicUtil.getRealPath((String)upload), (boolean)true);
        }
        File dataFile = new File(tmplDir + "/data");
        for (File mdiyModelJson : mdiyModelJsons = dataFile.listFiles(pathname -> pathname.getName().startsWith("MODEL_JSON"))) {
            String modelDataJson = FileUtil.readString((String)mdiyModelJson.getPath(), (Charset)StandardCharsets.UTF_8);
            int index = modelDataJson.lastIndexOf("}");
            ModelJsonBean modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelDataJson.substring(0, index + 1), ModelJsonBean.class);
            this.modelBiz.importModel("model", modelJsonBean, "cms");
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ModelEntity::getModelTableName, (Object)("MDIY_MODEL_" + modelJsonBean.getTableName()));
            ModelEntity modelEntity = (ModelEntity)this.modelBiz.getOne((Wrapper)wrapper);
            String modelEntityId = modelEntity.getId();
            String oldModelEntityId = modelDataJson.substring(index + 1);
            List categoryMaps = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CATEGORY WHERE MDIY_MODEL_ID = " + oldModelEntityId);
            Map categoryMap = (Map)categoryMaps.get(0);
            categoryMap.put("MDIY_MODEL_ID", modelEntityId);
            HashMap fieldsMap = new HashMap();
            fieldsMap.put("MDIY_MODEL_ID", categoryMap.get("MDIY_MODEL_ID"));
            HashMap whereMap = new HashMap();
            whereMap.put("id", categoryMap.get("id"));
            this.modelBiz.updateBySQL("CMS_CATEGORY", fieldsMap, whereMap);
        }
        for (File mdiyModel : mdiyModels = dataFile.listFiles(pathname -> pathname.getName().startsWith("MDIY_MODEL"))) {
            String modelTableName = FileNameUtil.mainName((File)mdiyModel);
            String modelDataJson = FileUtil.readString((String)(tmplDir + "/data/" + modelTableName + ".json"), (Charset)StandardCharsets.UTF_8);
            List modelData = JSONUtil.toList((String)modelDataJson, Map.class);
            modelData.forEach(item -> {
                item.put("CREATE_DATE", DateTime.of((long)((Long)item.get("CREATE_DATE"))));
                item.put("UPDATE_DATE", DateTime.of((long)((Long)item.get("UPDATE_DATE"))));
                this.modelBiz.insertBySQL(modelTableName, item);
            });
        }
        String appInfoJson = FileUtil.readString((String)(tmplDir + "/data/APP.json"), (Charset)StandardCharsets.UTF_8);
        AppEntity appEntity = (AppEntity)JSONUtil.toBean((String)appInfoJson, AppEntity.class);
        appEntity.setAppId(app.getAppId());
        IAppBiz appBiz = (IAppBiz)SpringUtil.getBean(IAppBiz.class);
        if (!appEntity.getAppStyle().equals(tmplName)) {
            appEntity.setAppStyle(tmplName);
        }
        appBiz.updateById((Object)appEntity);
        MapCacheUtil.remove((String)BasicUtil.getDomain());
        appBiz.updateCache();
        FileUtil.del((String)(tmplDir + "/data"));
    }

    private void delData() {
        this.modelBiz.excuteSql("DELETE FROM CMS_CONTENT");
        List categoryList = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CATEGORY");
        List categoryModelMap = categoryList.stream().filter(itemMap -> !Objects.isNull(itemMap.get("MDIY_MODEL_ID")) && StringUtils.isNotBlank((CharSequence)itemMap.get("MDIY_MODEL_ID").toString())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(categoryModelMap)) {
            this.modelBiz.excuteSql("DELETE FROM CMS_CATEGORY");
            return;
        }
        List modelIds = categoryModelMap.stream().map(mdiyModel -> mdiyModel.get("MDIY_MODEL_ID").toString()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(modelIds)) {
            List delModelEntities = this.modelBiz.listByIds(modelIds);
            delModelEntities.forEach(delModel -> {
                this.modelBiz.removeById(delModel);
                this.modelBiz.dropTable(delModel.getModelTableName());
            });
        }
        this.modelBiz.excuteSql("DELETE FROM CMS_CATEGORY");
    }

    private void htmlReplace(String htmlFilePath, String template, String appId) {
        File[] htmlFiles;
        File html = new File(htmlFilePath);
        for (File htmlFile : htmlFiles = html.listFiles()) {
            if (htmlFile.isDirectory()) {
                this.htmlReplace(htmlFile.getPath(), template, appId);
                continue;
            }
            String htmlContent = FileUtil.readString((File)htmlFile, (Charset)StandardCharsets.UTF_8);
            htmlContent = htmlContent.replaceAll("/" + template + "/" + appId, "");
            FileUtil.writeString((String)htmlContent, (File)htmlFile, (Charset)StandardCharsets.UTF_8);
        }
    }
}

