/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.store.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.MapCacheUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.mdiy.bean.ModelJsonBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.DictEntity;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.DictUtil;
import net.mingsoft.store.biz.IShareBiz;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="shareBizImpl")
@Transactional
public class ShareBizImpl
implements IShareBiz {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IModelBiz modelBiz;

    @Override
    public String backup(String backDir) throws IOException {
        String upload = MSProperties.upload.path;
        String template = MSProperties.upload.template;
        boolean enableWebsite = false;
        AppEntity app = BasicUtil.getWebsiteApp();
        if (app == null) {
            app = BasicUtil.getApp();
        } else {
            enableWebsite = true;
        }
        String appId = app.getId();
        String rootPath = BasicUtil.getRealPath((String)"/");
        if (!new File(backDir).isAbsolute()) {
            backDir = rootPath + File.separator + backDir;
        }
        String tmplBackDir = backDir;
        String tmplName = FileUtil.getName((String)backDir);
        File tmplFile = new File(rootPath + template + File.separator + appId + File.separator + tmplName);
        if (!tmplFile.exists()) {
            throw new BusinessException("\u5e94\u7528\u8bbe\u7f6e\u7ed1\u5b9a\u6a21\u677f\u4e0d\u5b58\u5728\uff01\u8bf7\u5728\u5e94\u7528\u8bbe\u7f6e\u5904\u5237\u65b0\u7f13\u5b58");
        }
        if (enableWebsite) {
            this.websiteExpTmpl(tmplFile.getPath());
        }
        FileUtil.copy((String)tmplFile.getPath(), (String)tmplBackDir, (boolean)true);
        boolean isCoOrGov = false;
        if (enableWebsite) {
            if (new File(rootPath + upload + File.separator + appId).exists()) {
                FileUtil.copyContent((File)new File(rootPath + upload + File.separator + appId), (File)new File(tmplBackDir + "/data/upload"), (boolean)true);
            }
            List contentList = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CONTENT WHERE APP_ID = " + appId);
            contentList.forEach(contentMap -> contentMap.remove("app_id"));
            String contents = JSONUtil.toJsonStr((Object)contentList);
            List categoryList = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CATEGORY WHERE APP_ID = " + appId);
            categoryList.forEach(categoryMap -> categoryMap.remove("app_id"));
            String categories = JSONUtil.toJsonStr((Object)categoryList);
            List appMap = (List)this.modelBiz.excuteSql("SELECT APP_NAME,APP_LOGO,APP_KEYWORD,APP_COPYRIGHT,APP_STYLE,APP_DESCRIPTION FROM APP WHERE ID = " + appId);
            String appInfo = JSONUtil.toJsonStr(appMap.get(0));
            FileUtil.writeString((String)appInfo, (String)(tmplBackDir + "/data/APP.json"), (Charset)StandardCharsets.UTF_8);
            FileUtil.writeString((String)contents, (String)(tmplBackDir + "/data/CMS_CONTENT.json"), (Charset)StandardCharsets.UTF_8);
            FileUtil.writeString((String)categories, (String)(tmplBackDir + "/data/CMS_CATEGORY.json"), (Charset)StandardCharsets.UTF_8);
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"APP_ID", (Object)appId)).and(wrapper1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper1.eq((Object)"MODEL_CUSTOM_TYPE", (Object)"form")).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)"model");
            });
            List modelEntities = this.modelBiz.list((Wrapper)wrapper);
            modelEntities.forEach(modelEntity -> {
                String modelName = modelEntity.getModelName();
                modelEntity.setModelName(modelName.replace(appId, ""));
                String modelTableName = modelEntity.getModelTableName();
                modelEntity.setModelTableName(modelTableName.replace(appId, ""));
                String modelJson = modelEntity.getModelJson();
                String[] s = modelTableName.split("_");
                String tableName = s[s.length - 1];
                String newTableName = tableName.replace(appId, "");
                modelJson = modelJson.replace(tableName, newTableName);
                modelEntity.setModelJson(modelJson);
                String modelEntityJson = JSONUtil.toJsonStr((Object)modelEntity);
                FileUtil.writeString((String)modelEntityJson, (String)(tmplBackDir + "/data/MODEL_JSON_" + modelEntity.getModelTableName() + ".json"), (Charset)StandardCharsets.UTF_8);
            });
        } else {
            File[] uploadFiles;
            File tmplUploadFile = new File(rootPath + File.separator + upload + "/" + appId);
            for (File file : uploadFiles = tmplUploadFile.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.copyDirectory((File)file, (File)new File(tmplBackDir + "/data/upload/" + FileUtil.getName((File)file)), (boolean)true);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)file, (File)new File(tmplBackDir + "/data/upload"), (boolean)true);
            }
            List contentList = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CONTENT ");
            List appMap = (List)this.modelBiz.excuteSql("SELECT APP_NAME,APP_LOGO,APP_KEYWORD,APP_COPYRIGHT,APP_STYLE,APP_DESCRIPTION FROM APP");
            List categoryList = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CATEGORY");
            List dictEntities = DictUtil.list((String)"\u6a21\u677f\u7c7b\u578b");
            if (CollectionUtil.isNotEmpty((Collection)dictEntities)) {
                isCoOrGov = true;
                contentList.forEach(content -> {
                    content.remove("PROGRESS_STATUS");
                    content.remove("content_title_css");
                    content.remove("CONTENT_STYLE");
                    content.remove("ORGANIZATION_ID");
                    content.remove("CATEGORY_IDS");
                    content.remove("PROGRESS_DESC");
                });
                categoryList.forEach(category -> {
                    String categoryUrls = category.get("CATEGORY_URLS").toString();
                    List categoryUrlsMap = JSONUtil.toList((String)categoryUrls, Map.class);
                    String categoryListUrls = category.get("CATEGORY_LIST_URLS").toString();
                    List categoryListUrlsMap = JSONUtil.toList((String)categoryListUrls, Map.class);
                    categoryListUrlsMap.forEach(categoryListUrl -> {
                        if (((DictEntity)dictEntities.get(0)).getDictLabel().equals(categoryListUrl.get("name").toString())) {
                            category.put("CATEGORY_LIST_URL", categoryListUrl.get("file"));
                        }
                    });
                    category.remove("CATEGORY_LIST_URLS");
                    categoryUrlsMap.forEach(categoryUrl -> {
                        if (((DictEntity)dictEntities.get(0)).getDictLabel().equals(categoryUrl.get("name").toString())) {
                            category.put("CATEGORY_URL", categoryUrl.get("file"));
                        }
                    });
                    category.remove("CATEGORY_URLS");
                });
                Map appData = (Map)appMap.get(0);
                appData.remove("APP_STYLES");
                appData.put("APP_STYLE", tmplName);
                this.coOrGovTmplExp(tmplBackDir);
            }
            String contents = JSONUtil.toJsonStr((Object)contentList);
            contents = contents.replaceAll("pboot", "xxx");
            contents = contents.replaceAll("Pboot", "xxx");
            String categories = JSONUtil.toJsonStr((Object)categoryList);
            String appInfo = JSONUtil.toJsonStr(appMap.get(0));
            FileUtil.writeString((String)appInfo, (String)(tmplBackDir + "/data/APP.json"), (Charset)StandardCharsets.UTF_8);
            FileUtil.writeString((String)contents, (String)(tmplBackDir + "/data/CMS_CONTENT.json"), (Charset)StandardCharsets.UTF_8);
            if (categories != null) {
                categories = categories.replaceAll("pboot", "xxx");
                categories = categories.replaceAll("Pboot", "xxx");
                FileUtil.writeString((String)categories, (String)(tmplBackDir + "/data/CMS_CATEGORY.json"), (Charset)StandardCharsets.UTF_8);
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ModelEntity::getModelCustomType, (Object)"form")).or()).eq(ModelEntity::getModelCustomType, (Object)"model");
            List modelEntities = this.modelBiz.list((Wrapper)wrapper);
            modelEntities.forEach(modelEntity -> {
                String modelEntityJson = JSONUtil.toJsonStr((Object)modelEntity);
                FileUtil.writeString((String)modelEntityJson, (String)(tmplBackDir + "/data/MODEL_JSON_" + modelEntity.getModelTableName() + ".json"), (Charset)StandardCharsets.UTF_8);
            });
        }
        String html = MSProperties.diy.htmlDir;
        if (StringUtils.isNotBlank((CharSequence)app.getAppDir())) {
            if (isCoOrGov) {
                FileUtil.copy((String)(rootPath + html + File.separator + app.getAppDir() + File.separator + tmplName), (String)(tmplBackDir + File.separator + "html"), (boolean)true);
            } else {
                FileUtil.copy((String)(rootPath + html + File.separator + app.getAppDir()), (String)(tmplBackDir + File.separator + "html"), (boolean)true);
            }
        } else if (isCoOrGov) {
            FileUtil.copy((String)(rootPath + html + File.separator + tmplName), (String)(tmplBackDir + File.separator + "html"), (boolean)true);
        } else {
            FileUtil.copy((String)(rootPath + html), (String)tmplBackDir, (boolean)true);
        }
        this.htmlReplace(tmplBackDir + File.separator + "html", template, appId);
        File zipFile = ZipUtil.zip((String)tmplBackDir);
        FileUtil.del((String)tmplBackDir);
        return zipFile.getPath();
    }

    @Override
    public void tmplUnZip(String appId, String tmplName) {
        this.importData(appId, tmplName);
    }

    @Override
    public void tmplUnZip(String tmplName) {
        this.delData();
        this.importData(null, tmplName);
    }

    private void importData(String appId, String tmplName) {
        File[] mdiyModelJsons;
        File[] files;
        String template = MSProperties.upload.template;
        String upload = MSProperties.upload.path;
        String rootPath = BasicUtil.getRealPath((String)"/");
        if (appId == null) {
            appId = BasicUtil.getApp().getId();
        }
        String tmplDir = rootPath + File.separator + template + File.separator + appId + File.separator + tmplName;
        this.impHandleCssAndHtml(tmplDir);
        File dataUploadFile = new File(tmplDir + "/data/upload/");
        ArrayList<String> uploadDirFileNames = new ArrayList<String>();
        for (File file : files = dataUploadFile.listFiles()) {
            if (!(file.getName().equals("cms") || file.getName().equals("appLogo") || file.getName().matches("[\\d]+"))) {
                uploadDirFileNames.add(file.getName());
            }
            FileUtil.copy((File)file, (File)new File(BasicUtil.getRealPath((String)(upload + File.separator + appId))), (boolean)true);
        }
        this.saveData(uploadDirFileNames, tmplDir, appId);
        File dataFile = new File(tmplDir + "/data");
        for (File mdiyModelJson : mdiyModelJsons = dataFile.listFiles(pathname -> pathname.getName().startsWith("MODEL_JSON"))) {
            String modelEntityJson = FileUtil.readString((String)mdiyModelJson.getPath(), (Charset)StandardCharsets.UTF_8);
            ModelEntity modelEntity = (ModelEntity)JSONUtil.toBean((String)modelEntityJson, ModelEntity.class);
            String modelJson = modelEntity.getModelJson();
            ModelJsonBean modelJsonBean = (ModelJsonBean)JSONUtil.toBean((String)modelJson, ModelJsonBean.class);
            modelJsonBean.setTableName(modelJsonBean.getTableName());
            modelJsonBean.setTitle(modelEntity.getModelName());
            modelJsonBean.setField(modelEntity.getModelField());
            this.modelBiz.importModel(modelEntity.getModelCustomType(), modelJsonBean, modelEntity.getModelType());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            if (!"cms".equals(modelEntity.getModelType())) continue;
            wrapper.eq(ModelEntity::getModelTableName, (Object)("MDIY_MODEL_" + modelJsonBean.getTableName()));
            ModelEntity mdiyModelEntity = (ModelEntity)this.modelBiz.getOne((Wrapper)wrapper);
            String mdiyModelEntityId = mdiyModelEntity.getId();
            List categoryMaps = (List)this.modelBiz.excuteSql("SELECT * FROM CMS_CATEGORY WHERE MDIY_MODEL_ID = " + modelEntity.getId());
            if (!CollectionUtil.isNotEmpty((Collection)categoryMaps)) continue;
            for (Map categoryMap : categoryMaps) {
                categoryMap.put("MDIY_MODEL_ID", mdiyModelEntityId);
                HashMap fieldsMap = new HashMap();
                fieldsMap.put("MDIY_MODEL_ID", categoryMap.get("MDIY_MODEL_ID"));
                HashMap whereMap = new HashMap();
                whereMap.put("id", categoryMap.get("id"));
                this.modelBiz.updateBySQL("CMS_CATEGORY", fieldsMap, whereMap);
            }
        }
        FileUtil.del((String)(tmplDir + "/data"));
    }

    private void saveData(List<String> uploadDirFileNames, String tmplDir, String appId) {
        String categoryJson = this.impHandleJsonData(uploadDirFileNames, tmplDir, "CMS_CATEGORY.json", appId);
        String contentJson = this.impHandleJsonData(uploadDirFileNames, tmplDir, "CMS_CONTENT.json", appId);
        String appJson = this.impHandleJsonData(uploadDirFileNames, tmplDir, "APP.json", appId);
        HashMap<String, Long> categoryIds = new HashMap<String, Long>();
        HashMap<String, Long> contentIds = new HashMap<String, Long>();
        boolean isCoOrGov = false;
        List dictEntities = DictUtil.list((String)"\u6a21\u677f\u7c7b\u578b");
        if (CollectionUtil.isNotEmpty((Collection)dictEntities)) {
            isCoOrGov = true;
        }
        List categories = JSONUtil.toList((String)categoryJson, TreeMap.class);
        ArrayList categoryListTreeMap = new ArrayList();
        categories.forEach(category -> {
            TreeMap categoryTreeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            BeanUtil.copyProperties((Object)category, categoryTreeMap, (String[])new String[0]);
            categoryListTreeMap.add(categoryTreeMap);
        });
        List contents = JSONUtil.toList((String)contentJson, TreeMap.class);
        ArrayList contentListTreeMap = new ArrayList();
        contents.forEach(content -> {
            TreeMap contentTreeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            BeanUtil.copyProperties((Object)content, contentTreeMap, (String[])new String[0]);
            contentListTreeMap.add(contentTreeMap);
        });
        TreeMap appMap = (TreeMap)JSONUtil.toBean((String)appJson, TreeMap.class);
        TreeMap appMapTreeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        BeanUtil.copyProperties((Object)JSONUtil.toBean((String)appJson, TreeMap.class), appMapTreeMap, (String[])new String[0]);
        String appStyle = appMap.get("APP_STYLE").toString();
        if (isCoOrGov) {
            ArrayList appStyles = new ArrayList();
            appMap.put("APP_STYLE", "");
            for (int i = 0; i < dictEntities.size(); ++i) {
                HashMap<String, String> style = new HashMap<String, String>();
                style.put("name", ((DictEntity)dictEntities.get(i)).getDictLabel());
                if (i == 0) {
                    style.put("template", appStyle);
                } else {
                    style.put("template", "");
                }
                appStyles.add(style);
            }
            appMap.put("app_styles", JSONUtil.toJsonStr(appStyles));
            categoryListTreeMap.forEach(category -> {
                ArrayList categoryUrlList = new ArrayList();
                ArrayList categoryListUrlList = new ArrayList();
                String categoryUrl = "";
                String categoryListUrl = "";
                if (!Objects.isNull(category.get("category_url"))) {
                    categoryUrl = category.get("category_url").toString();
                }
                if (!Objects.isNull(category.get("category_list_url"))) {
                    categoryListUrl = category.get("category_list_url").toString();
                }
                for (int i = 0; i < dictEntities.size(); ++i) {
                    HashMap<String, String> categoryUrls = new HashMap<String, String>();
                    HashMap<String, String> categoryListUrls = new HashMap<String, String>();
                    categoryUrls.put("name", ((DictEntity)dictEntities.get(i)).getDictLabel());
                    categoryListUrls.put("name", ((DictEntity)dictEntities.get(i)).getDictLabel());
                    if (i == 0) {
                        categoryUrls.put("template", appStyle);
                        categoryUrls.put("file", categoryUrl);
                        categoryListUrls.put("template", appStyle);
                        categoryListUrls.put("file", categoryListUrl);
                    } else {
                        categoryUrls.put("template", "");
                        categoryUrls.put("file", "");
                        categoryListUrls.put("template", "");
                        categoryListUrls.put("file", "");
                    }
                    categoryUrlList.add(categoryUrls);
                    categoryListUrlList.add(categoryListUrls);
                }
                category.put("category_url", "");
                category.put("category_urls", JSONUtil.toJsonStr(categoryUrlList));
                category.put("category_list_url", "");
                category.put("category_list_urls", JSONUtil.toJsonStr(categoryListUrlList));
            });
            contentListTreeMap.forEach(content -> {
                content.put("progress_status", "\u7ec8\u5ba1\u901a\u8fc7");
                content.put("content_style", ((DictEntity)dictEntities.get(0)).getDictValue());
                content.put("content_title_css", "color:;");
            });
            this.isCoOrGovTagReplace(tmplDir);
        }
        appMap.put("id", appId);
        appMap.put("APP_URL", BasicUtil.getUrl());
        HashMap<String, String> whereMap = new HashMap<String, String>();
        whereMap.put("id", appId);
        this.modelBiz.updateBySQL("APP", (Map)appMap, whereMap);
        IAppBiz appBiz = (IAppBiz)SpringUtil.getBean(IAppBiz.class);
        MapCacheUtil.remove((String)BasicUtil.getDomain());
        appBiz.updateCache();
        Snowflake snowflake = IdUtil.getSnowflake();
        for (Map category2 : categoryListTreeMap) {
            long snowId = snowflake.nextId();
            categoryIds.put(category2.get("id").toString(), snowId);
        }
        for (Map category2 : categoryListTreeMap) {
            category2.put("create_date", DateTime.of((long)((Long)category2.get("create_date"))));
            category2.put("update_date", DateTime.of((long)((Long)category2.get("update_date"))));
            if (Objects.isNull(category2.get("category_display"))) {
                category2.put("category_display", "enable");
            }
            category2.put("id", categoryIds.get(String.valueOf(category2.get("id"))));
            if (categoryIds.containsKey(String.valueOf(category2.get("top_id")))) {
                category2.put("top_id", categoryIds.get(String.valueOf(category2.get("top_id"))));
            } else {
                category2.put("top_id", "0");
            }
            category2.put("category_id", categoryIds.get(String.valueOf(category2.get("category_id"))));
            Object parentIds = category2.get("category_parent_ids");
            if (parentIds != null && !"".equals(parentIds)) {
                String[] ids = parentIds.toString().split(",");
                List list = Arrays.stream(ids).map(id -> (Long)categoryIds.get(id)).collect(Collectors.toList());
                category2.put("category_parent_ids", StrUtil.join((CharSequence)",", list));
            }
            this.LOG.debug("\u5f53\u524d\u680f\u76ee\u6570\u636e: {}", (Object)category2.toString());
            this.modelBiz.insertBySQL("CMS_CATEGORY", category2);
        }
        int i = 0;
        for (Map content2 : contentListTreeMap) {
            long snowId = snowflake.nextId();
            contentIds.put(content2.get("id").toString(), snowId);
            content2.put("id", snowId);
            content2.put("category_id", categoryIds.get(String.valueOf(content2.get("category_id"))));
            content2.put("content_datetime", DateTime.of((long)(System.currentTimeMillis() + (long)i * 1000L)));
            content2.put("update_date", new Date());
            content2.put("create_date", new Date());
            this.modelBiz.insertBySQL("CMS_CONTENT", content2);
            ++i;
        }
        this.templateIdReplace(tmplDir, categoryIds, contentIds, uploadDirFileNames);
    }

    private void delData() {
        AppEntity app = BasicUtil.getWebsiteApp();
        if (app == null) {
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u6587\u7ae0\u8868\u6570\u636e...");
            this.modelBiz.excuteSql("DELETE FROM cms_content");
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u680f\u76ee\u8868\u6570\u636e...");
            this.modelBiz.excuteSql("DELETE FROM cms_category");
        } else {
            app = BasicUtil.getApp();
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u7ad9\u70b9{}\u6587\u7ae0\u8868\u6570\u636e...", (Object)app.getAppId());
            this.modelBiz.excuteSql("DELETE FROM cms_content WHERE APP_ID = " + app.getId());
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u7ad9\u70b9{}\u680f\u76ee\u8868\u6570\u636e...", (Object)app.getAppId());
            this.modelBiz.excuteSql("DELETE FROM cms_category WHERE APP_ID = " + app.getId());
            this.LOG.debug("\u5f00\u59cb\u5220\u9664\u7ad9\u70b9{}\u81ea\u5b9a\u4e49\u6a21\u578b\u548c\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6570\u636e...", (Object)app.getAppId());
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"APP_ID", (Object)app.getAppId())).and(wrapper1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper1.eq((Object)"MODEL_CUSTOM_TYPE", (Object)"form")).or()).eq((Object)"MODEL_CUSTOM_TYPE", (Object)"model");
            });
            List modelEntityList = this.modelBiz.list((Wrapper)wrapper);
            List modelIds = modelEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.modelBiz.delete(modelIds);
        }
        String upload = MSProperties.upload.path;
        String rootPath = BasicUtil.getRealPath((String)"/");
        this.LOG.debug("\u5f00\u59cb\u5220\u9664upload\u8d44\u6e90...");
        FileUtil.del((String)(rootPath + upload + "/" + BasicUtil.getApp().getId()));
    }

    private void impHandleCssAndHtml(String tmplFilePath) {
        List tmplDirFiles = FileUtil.loopFiles((String)tmplFilePath);
        tmplDirFiles.forEach(file -> {
            if ("css".equals(FileUtil.extName((File)file))) {
                String cssContent = FileUtil.readString((File)file, (Charset)StandardCharsets.UTF_8);
                cssContent = cssContent.replaceAll("url\\(/upload/1", "url(../images");
                cssContent = cssContent.replaceAll("url\\(\"/upload/1", "url(\"../images");
                cssContent = cssContent.replaceAll("url\\(/upload", "url(../images");
                cssContent = cssContent.replaceAll("url\\(\"/upload", "url(\"../images");
                FileUtil.writeString((String)cssContent, (File)file, (Charset)StandardCharsets.UTF_8);
            }
        });
    }

    private String impHandleJsonData(List<String> uploadDirFileNames, String tmplDir, String jsonName, String appId) {
        String jsonStr = FileUtil.readString((String)(tmplDir + "/data/" + jsonName), (Charset)StandardCharsets.UTF_8);
        for (String uploadDirFileName : uploadDirFileNames) {
            jsonStr = jsonStr.replaceAll("/upload/" + uploadDirFileName, "/upload/" + appId + "/" + uploadDirFileName);
        }
        jsonStr = jsonStr.replaceAll("/upload/[\\d]+/", "/upload/" + appId + "/");
        return jsonStr;
    }

    private void htmlReplace(String htmlFilePath, String template, String appId) {
        File html = new File(htmlFilePath);
        File[] htmlFiles = html.listFiles();
        String appUrl = BasicUtil.getApp().getAppUrl();
        for (File htmlFile : htmlFiles) {
            if (htmlFile.isDirectory()) {
                this.htmlReplace(htmlFile.getPath(), template, appId);
                continue;
            }
            String htmlContent = FileUtil.readString((File)htmlFile, (Charset)StandardCharsets.UTF_8);
            htmlContent = htmlContent.replaceAll(appUrl + "//", "/");
            htmlContent = htmlContent.replaceAll(appUrl + "/", "/");
            htmlContent = htmlContent.replaceAll(appUrl, "/");
            htmlContent = htmlContent.replaceAll("/" + template + "/" + appId, "");
            htmlContent = htmlContent.replaceAll("upload/" + appId, "upload");
            FileUtil.writeString((String)htmlContent, (File)htmlFile, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void templateIdReplace(String templatePath, Map<String, Long> categoryIds, Map<String, Long> contentIds, List<String> uploadDirFileNames) {
        categoryIds.put("0", 0L);
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            List fileLines = FileUtil.readLines((File)templateFile, (Charset)StandardCharsets.UTF_8);
            String line = "";
            String newFile = "";
            Iterator linesIterator = fileLines.iterator();
            String appId = BasicUtil.getApp().getId();
            while (linesIterator.hasNext()) {
                boolean findTypeids;
                boolean findForm;
                boolean dataId;
                Pattern tmplListPattern;
                Matcher matcher;
                boolean typeId;
                line = (String)linesIterator.next();
                if (CollectionUtil.isNotEmpty((Collection)uploadDirFileNames)) {
                    for (String uploadDirFileName : uploadDirFileNames) {
                        line = line.replaceAll("upload/" + uploadDirFileName, "upload/" + appId + "/" + uploadDirFileName);
                    }
                } else {
                    line = line.replaceAll("upload/[\\d]+/", "upload/" + appId + "/");
                }
                if (typeId = (matcher = (tmplListPattern = Pattern.compile("typeid[\\s]?=[\\s]?([\"|'])?([\\d]+)([\"|']?)")).matcher(line)).find()) {
                    String categoryId = "";
                    if (Objects.nonNull(categoryIds.get(matcher.group(2)))) {
                        categoryId = ((Long)categoryIds.get(matcher.group(2))).toString();
                    } else {
                        this.LOG.debug("\u7ad9\u70b9{} \u680f\u76eeid{}\u66ff\u6362\u5f02\u5e38", (Object)appId, (Object)matcher.group(2));
                    }
                    String newLine = matcher.replaceAll("typeid=\"" + categoryId + "\"");
                    newFile = newFile + newLine + "\n";
                }
                if (dataId = (matcher = (tmplListPattern = Pattern.compile("dataid[\\s]?=[\\s]?([\"|'])?([\\d]+)([\"|']?)")).matcher(line)).find()) {
                    String contentId = "";
                    if (Objects.nonNull(contentIds.get(matcher.group(2)))) {
                        contentId = ((Long)contentIds.get(matcher.group(2))).toString();
                    } else {
                        this.LOG.debug("\u7ad9\u70b9{} \u6587\u7ae0id{}\u66ff\u6362\u5f02\u5e38", (Object)appId, (Object)matcher.group(2));
                    }
                    String newLine = matcher.replaceAll("dataid=\"" + contentId + "\"");
                    newFile = newFile + newLine + "\n";
                }
                if (findForm = (matcher = (tmplListPattern = Pattern.compile("value=\\D?([\\d,+]*)\\D?[\\s\\S]*name=\\S?categoryIds\\S?")).matcher(line)).find()) {
                    String inputCategoryIds;
                    String oldIds = inputCategoryIds = matcher.group(1);
                    if (StringUtils.isNotBlank((CharSequence)inputCategoryIds) && inputCategoryIds.contains(",")) {
                        String[] categoryIdArr;
                        StringBuilder newCategoryIds = new StringBuilder();
                        for (String s : categoryIdArr = inputCategoryIds.split(",")) {
                            if (StringUtils.isNotBlank((CharSequence)newCategoryIds)) {
                                newCategoryIds.append(",");
                            }
                            if (Objects.nonNull(categoryIds.get(s))) {
                                newCategoryIds.append(categoryIds.get(s));
                                continue;
                            }
                            this.LOG.debug("\u7ad9\u70b9{} \u66ff\u6362\u641c\u7d22\u680f\u76eecategoryIds\u4e2d\u7684{}\u5f02\u5e38", (Object)appId, (Object)s);
                        }
                        inputCategoryIds = newCategoryIds.toString();
                    } else if (Objects.nonNull(categoryIds.get(inputCategoryIds))) {
                        inputCategoryIds = ((Long)categoryIds.get(inputCategoryIds)).toString();
                    } else {
                        this.LOG.debug("\u7ad9\u70b9{} \u66ff\u6362\u641c\u7d22\u680f\u76eecategoryIds\u4e2d\u7684{}\u5f02\u5e38", (Object)appId, (Object)inputCategoryIds);
                    }
                    String group = matcher.group();
                    group = group.replace(oldIds, inputCategoryIds);
                    String newLine = matcher.replaceAll(group);
                    newFile = newFile + newLine + "\n";
                }
                if (findTypeids = (matcher = (tmplListPattern = Pattern.compile("typeids=[\"']?([\\d,]+)[\"']?")).matcher(line)).find()) {
                    String oldTypeids = matcher.group(1);
                    String[] typeidArray = oldTypeids.split(",");
                    StringBuilder newTypeids = new StringBuilder();
                    for (String typeid : typeidArray) {
                        if (StringUtils.isNotBlank((CharSequence)newTypeids)) {
                            newTypeids.append(",");
                        }
                        String newTypeid = ((Long)categoryIds.get(typeid)).toString();
                        newTypeids.append(newTypeid);
                    }
                    String group = matcher.group();
                    group = group.replace(oldTypeids, newTypeids);
                    String newLine = matcher.replaceAll(group);
                    newFile = newFile + newLine + "\n";
                }
                if (typeId || dataId || findForm || findTypeids) continue;
                newFile = newFile + line + "\n";
            }
            FileUtil.writeString((String)newFile, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }

    private void isCoOrGovTagReplace(String templatePath) {
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            String fileContent = FileUtil.readString((File)templateFile, (Charset)StandardCharsets.UTF_8);
            fileContent = fileContent.replaceAll("\\{ms:global.html/}/\\{ms:global.template/}", "\\{ms:global.html/}");
            fileContent = fileContent.replaceAll("\\{ms:global.html/}", "{ms:global.html/}/{ms:global.template/}");
            FileUtil.writeString((String)fileContent, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }

    private void coOrGovTmplExp(String templatePath) {
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            String fileContent = FileUtil.readString((File)templateFile, (Charset)StandardCharsets.UTF_8);
            fileContent = fileContent.replaceAll("\\{ms:global.html/}/\\{ms:global.template/}", "\\{ms:global.html/}");
            FileUtil.writeString((String)fileContent, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }

    private void websiteExpTmpl(String templatePath) {
        String appId = BasicUtil.getApp().getId();
        List templateFiles = FileUtil.loopFiles((String)templatePath, file -> FileUtil.extName((File)file).equals("html") || FileUtil.extName((File)file).equals("htm"));
        templateFiles.forEach(templateFile -> {
            List fileLines = FileUtil.readLines((File)templateFile, (Charset)StandardCharsets.UTF_8);
            String line2 = "";
            String newFile = "";
            for (String line2 : fileLines) {
                Pattern pattern = Pattern.compile("tableName.*=\"(([\\s\\S]*?)\\d+)\"");
                Matcher matcher = pattern.matcher(line2);
                boolean model = matcher.find();
                if (model) {
                    String newLine = matcher.replaceAll("tableName=\"" + matcher.group(2) + "\"");
                    newFile = newFile + newLine + "\n";
                }
                if (model) continue;
                newFile = newFile + line2 + "\n";
            }
            FileUtil.writeString((String)newFile, (File)templateFile, (Charset)StandardCharsets.UTF_8);
        });
    }
}

