/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.ovh.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minidev.ovh.api.iot.OvhGrafanaUser;
import net.minidev.ovh.api.iot.OvhIOTApp;
import net.minidev.ovh.api.iot.OvhIOTCluster;
import net.minidev.ovh.api.iot.OvhIOTToken;
import net.minidev.ovh.api.iot.OvhTag;
import net.minidev.ovh.core.ApiOvhBase;
import net.minidev.ovh.core.ApiOvhCore;

public class ApiOvhIot
extends ApiOvhBase {
    private static TypeReference<ArrayList<OvhIOTCluster>> t1 = new TypeReference<ArrayList<OvhIOTCluster>>(){};
    private static TypeReference<ArrayList<OvhIOTApp>> t2 = new TypeReference<ArrayList<OvhIOTApp>>(){};
    private static TypeReference<ArrayList<OvhIOTToken>> t3 = new TypeReference<ArrayList<OvhIOTToken>>(){};

    public ApiOvhIot(ApiOvhCore core) {
        super(core);
    }

    public ArrayList<OvhIOTCluster> availableCluster_GET() throws IOException {
        String qPath = "/iot/availableCluster";
        StringBuilder sb = this.path(qPath, new Object[0]);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t1);
    }

    public ArrayList<OvhIOTApp> app_GET() throws IOException {
        String qPath = "/iot/app";
        StringBuilder sb = this.path(qPath, new Object[0]);
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t2);
    }

    public OvhIOTApp app_POST(String name, String description, String cluster) throws IOException {
        String qPath = "/iot/app";
        StringBuilder sb = this.path(qPath, new Object[0]);
        HashMap o = new HashMap();
        this.addBody(o, "name", name);
        this.addBody(o, "description", description);
        this.addBody(o, "cluster", cluster);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhIOTApp)this.convertTo(resp, OvhIOTApp.class);
    }

    public OvhIOTApp app_app_GET(String app) throws IOException {
        String qPath = "/iot/app/{app}";
        StringBuilder sb = this.path(qPath, new Object[]{app});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhIOTApp)this.convertTo(resp, OvhIOTApp.class);
    }

    public void app_app_DELETE(String app) throws IOException {
        String qPath = "/iot/app/{app}";
        StringBuilder sb = this.path(qPath, new Object[]{app});
        this.exec(qPath, "DELETE", sb.toString(), null);
    }

    public OvhIOTApp app_app_PUT(String app, String description, String cluster) throws IOException {
        String qPath = "/iot/app/{app}";
        StringBuilder sb = this.path(qPath, new Object[]{app});
        HashMap o = new HashMap();
        this.addBody(o, "description", description);
        this.addBody(o, "cluster", cluster);
        String resp = this.exec(qPath, "PUT", sb.toString(), o);
        return (OvhIOTApp)this.convertTo(resp, OvhIOTApp.class);
    }

    public OvhIOTToken app_app_token_token_GET(String app, String token) throws IOException {
        String qPath = "/iot/app/{app}/token/{token}";
        StringBuilder sb = this.path(qPath, new Object[]{app, token});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (OvhIOTToken)this.convertTo(resp, OvhIOTToken.class);
    }

    public void app_app_token_token_DELETE(String app, String token) throws IOException {
        String qPath = "/iot/app/{app}/token/{token}";
        StringBuilder sb = this.path(qPath, new Object[]{app, token});
        this.exec(qPath, "DELETE", sb.toString(), null);
    }

    public OvhIOTToken app_app_token_token_PUT(String app, String token, String description, OvhTag[] tagList) throws IOException {
        String qPath = "/iot/app/{app}/token/{token}";
        StringBuilder sb = this.path(qPath, new Object[]{app, token});
        HashMap o = new HashMap();
        this.addBody(o, "description", description);
        this.addBody(o, "tagList", tagList);
        String resp = this.exec(qPath, "PUT", sb.toString(), o);
        return (OvhIOTToken)this.convertTo(resp, OvhIOTToken.class);
    }

    public ArrayList<OvhIOTToken> app_app_token_GET(String app) throws IOException {
        String qPath = "/iot/app/{app}/token";
        StringBuilder sb = this.path(qPath, new Object[]{app});
        String resp = this.exec(qPath, "GET", sb.toString(), null);
        return (ArrayList)this.convertTo(resp, t3);
    }

    public OvhIOTToken app_app_token_POST(String app, String description, OvhTag[] tagList) throws IOException {
        String qPath = "/iot/app/{app}/token";
        StringBuilder sb = this.path(qPath, new Object[]{app});
        HashMap o = new HashMap();
        this.addBody(o, "description", description);
        this.addBody(o, "tagList", tagList);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhIOTToken)this.convertTo(resp, OvhIOTToken.class);
    }

    public OvhIOTApp goodies_register_POST(String activationCode) throws IOException {
        String qPath = "/iot/goodies/register";
        StringBuilder sb = this.path(qPath, new Object[0]);
        HashMap o = new HashMap();
        this.addBody(o, "activationCode", activationCode);
        String resp = this.exec(qPath, "POST", sb.toString(), o);
        return (OvhIOTApp)this.convertTo(resp, OvhIOTApp.class);
    }

    public OvhGrafanaUser app_app_token_token_actions_addGrafana_PUT(String app, String token) throws IOException {
        String qPath = "/iot/app/{app}/token/{token}/actions/addGrafana";
        StringBuilder sb = this.path(qPath, new Object[]{app, token});
        String resp = this.exec(qPath, "PUT", sb.toString(), null);
        return (OvhGrafanaUser)this.convertTo(resp, OvhGrafanaUser.class);
    }
}

