package net.morher.ui.connect.html;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import net.morher.ui.connect.api.action.Clickable;
import net.morher.ui.connect.api.action.ReadableInput;
import net.morher.ui.connect.api.action.WriteableInput;
import net.morher.ui.connect.api.mapping.ActionHandlerFactory;

public class ActionHandler implements Clickable, ReadableInput, WriteableInput {
    private final HtmlElement element;

    public ActionHandler(HtmlElement element) {
        this.element = element;
    }

    @Override
    public String getValue() {
        if (element instanceof HtmlInput) {
            return ((HtmlInput) element).getValueAttribute();
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        if (element instanceof HtmlInput) {
            ((HtmlInput) element).setValueAttribute(value);
        }
    }

    @Override
    public void click() {
        try {
            element.click();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doubleClick() {
        try {
            element.dblClick();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Factory implements ActionHandlerFactory<HtmlElementContext, ActionHandler> {
        INSTANCE;

        @Override
        public ActionHandler buildActionHandler(HtmlElementContext context) {
            return new ActionHandler(context.getElement());
        }
    }
}
