package net.morher.ui.connect.html;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import net.morher.ui.connect.api.action.Clickable;
import net.morher.ui.connect.api.action.ReadableInput;
import net.morher.ui.connect.api.action.ReadableLabel;
import net.morher.ui.connect.api.action.WriteableInput;

public class HtmlElementContext implements Clickable, ReadableLabel, ReadableInput, WriteableInput {
    private final HtmlElementContext parent;
    private HtmlElement element;

    public HtmlElementContext(HtmlElementContext parent, HtmlElement element) {
        this.parent = parent;
        this.element = element;
    }

    public HtmlElement getElement() {
        return element;
    }

    @SuppressWarnings("unchecked")
    public <E extends HtmlElement> E getElementAs(Class<E> elementType) {
        HtmlElement element = getElement();
        if (elementType.isInstance(element)) {
            return (E) element;
        }
        throw new RuntimeException("Element er av uventet type");
    }

    public HtmlElementContext getParent() {
        return parent;
    }

    @Override
    public String getText() {
        return getElementAs(HtmlElement.class).asText();
    }

    @Override
    public String getValue() {
        return getElementAs(HtmlInput.class).getValueAttribute();
    }

    @Override
    public void setValue(String value) {
        getElementAs(HtmlInput.class).setValueAttribute(value);
    }

    @Override
    public void click() {
        try {
            getElement().click();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doubleClick() {
        try {
            getElement().dblClick();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

}
