/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class TinyHealth {
    public static Result ok() {
        return new Result(Status.OK, null);
    }

    public static Result ok(String message) {
        return new Result(Status.OK, String.valueOf(message));
    }

    public static Result unhealthy(String message) {
        return new Result(Status.UNHEALTHY, message);
    }

    private TinyHealth() {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Result {
        private final Status status;
        private final String message;

        public Result(Status status, String message) {
            this.status = Objects.requireNonNull(status, "status == null");
            this.message = message;
        }

        @JsonProperty(value="status")
        public Status getStatus() {
            return this.status;
        }

        @JsonProperty(value="message")
        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "Result{status=" + this.status + ", message='" + this.message + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.status == result.status && this.message.equals(result.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.message});
        }
    }

    public static enum Status {
        OK,
        UNHEALTHY,
        ERROR;

    }

    @FunctionalInterface
    public static interface ReadyCheck {
        public Result readyCheck();
    }

    @FunctionalInterface
    public static interface HealthCheck {
        public Result healthCheck();
    }
}

