/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TinyHttpHandler
implements HttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyHttpHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            exchange.getResponseHeaders().set("Server", "tiny-server");
            switch (exchange.getRequestMethod()) {
                case "GET": {
                    this.doGet(exchange);
                    return;
                }
                case "POST": {
                    this.doPost(exchange);
                    return;
                }
                case "HEAD": {
                    this.doHead(exchange);
                    return;
                }
                case "OPTIONS": {
                    this.doOptions(exchange);
                    return;
                }
                case "TRACE": {
                    this.doTrace(exchange);
                    return;
                }
                case "PUT": {
                    this.doPut(exchange);
                    return;
                }
                case "DELETE": {
                    this.doDelete(exchange);
                    return;
                }
                default: {
                    LOGGER.warn("Unknown request method: {} {} HTTP/1.1", (Object)exchange.getRequestMethod(), (Object)exchange.getRequestURI().getPath());
                    exchange.sendResponseHeaders(405, 0L);
                    return;
                }
            }
        }
        catch (Exception e) {
            if (exchange.getResponseCode() <= 0) {
                LOGGER.warn("Exception handling: {} {} HTTP/1.1", new Object[]{exchange.getRequestMethod(), exchange.getRequestURI().getPath(), e});
                exchange.sendResponseHeaders(500, 0L);
                return;
            } else {
                LOGGER.error("Exception handling: {} {} HTTP/1.1", new Object[]{exchange.getRequestMethod(), exchange.getRequestURI().getPath(), e});
            }
            return;
        }
        finally {
            exchange.close();
        }
    }

    protected void doGet(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doPost(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doHead(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, -1L);
    }

    protected void doOptions(HttpExchange exchange) throws IOException {
        TreeSet<String> methods = new TreeSet<String>();
        TreeSet<String> corsMethods = new TreeSet<String>();
        block16: for (Method method : this.getClass().getDeclaredMethods()) {
            switch (method.getName()) {
                case "doGet": {
                    methods.add("GET");
                    corsMethods.add("GET");
                    continue block16;
                }
                case "doPost": {
                    methods.add("POST");
                    continue block16;
                }
                case "doHead": {
                    methods.add("HEAD");
                    continue block16;
                }
                case "doTrace": {
                    methods.add("TRACE");
                    continue block16;
                }
                case "doPut": {
                    methods.add("PUT");
                    continue block16;
                }
                case "doDelete": {
                    methods.add("DELETE");
                    continue block16;
                }
            }
        }
        if (!methods.isEmpty()) {
            exchange.getResponseHeaders().set("Allow", String.join((CharSequence)", ", methods));
        }
        if (!corsMethods.isEmpty()) {
            exchange.getResponseHeaders().set("Access-Control-Allow-Methods", String.join((CharSequence)", ", corsMethods));
        }
        if (methods.isEmpty() && corsMethods.isEmpty()) {
            exchange.sendResponseHeaders(500, 0L);
        } else {
            exchange.sendResponseHeaders(204, -1L);
        }
    }

    protected void doTrace(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doPut(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doDelete(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }
}

