/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.tiny.http.TinyHealth;
import net.morimekta.tiny.http.TinyHealthHttpHandler;
import net.morimekta.tiny.http.TinyHttpHandler;
import net.morimekta.tiny.http.TinyHttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TinyReadyHttpHandler
extends TinyHttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyReadyHttpHandler.class);
    private final Map<String, TinyHealth.ReadyCheck> readyChecks;

    public TinyReadyHttpHandler(Map<String, TinyHealth.ReadyCheck> readyChecks) {
        this.readyChecks = readyChecks;
    }

    @Override
    protected void doGet(HttpExchange exchange) throws IOException {
        Map<String, String> params = TinyHttpUtil.getExchangeQuery(exchange);
        TreeMap out = new TreeMap();
        AtomicInteger status = new AtomicInteger(200);
        this.readyChecks.forEach((name, check) -> {
            try {
                TinyHealth.Result result = check.readyCheck();
                if (result.getStatus() != TinyHealth.Status.OK) {
                    LOGGER.warn("Non OK result: {}", (Object)result);
                    status.set(500);
                }
                out.put(name, result);
            }
            catch (Exception e) {
                LOGGER.warn("Exception in readyCheck(): {}", (Object)e.getMessage(), (Object)e);
                out.put(name, new TinyHealth.Result(TinyHealth.Status.ERROR, e.getClass().getSimpleName() + ": " + e.getMessage()));
                status.set(500);
            }
        });
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        exchange.sendResponseHeaders(status.get(), 0L);
        try (OutputStream os = exchange.getResponseBody();){
            if (params.get("pretty") != null) {
                os.write((TinyHealthHttpHandler.MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(out) + "\n").getBytes(StandardCharsets.UTF_8));
            } else {
                TinyHealthHttpHandler.MAPPER.writeValue(os, out);
            }
        }
    }
}

