/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.request;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.motionintelligence.client.api.Address;
import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.exception.Route360ClientRuntimeException;
import net.motionintelligence.client.api.request.GetRequest;
import net.motionintelligence.client.api.response.GeocodingResponse;
import org.boon.json.JsonFactory;
import org.boon.json.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocodingRequest
implements GetRequest<String, GeocodingResponse> {
    private static final String REST_URI = "http://geocode.arcgis.com";
    private static final String PATH_SINGLE_ADDRESS = "arcgis/rest/services/World/GeocodeServer/findAddressCandidates";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeocodingRequest.class);
    private static final ObjectMapper JSON_PARSER = JsonFactory.create();
    private final Client client;
    private final Map<Option, String> requestOptions;

    public GeocodingRequest(Client client) {
        this(client, new EnumMap<Option, String>(Option.class));
    }

    public GeocodingRequest(Client client, Map<Option, String> extraOptions) {
        this.client = client;
        this.requestOptions = extraOptions;
    }

    @Override
    public GeocodingResponse get(String singleLineAddress) throws Route360ClientException {
        return this.get((WebTarget webTarget) -> webTarget.queryParam("singleLine", new Object[]{singleLineAddress}));
    }

    @Override
    public GeocodingResponse get(Address address) throws Route360ClientException {
        return this.get((WebTarget webTarget) -> this.conditionalQueryParam("address", address.street, this.conditionalQueryParam("address2", address.streetDetails, this.conditionalQueryParam("city", address.city, this.conditionalQueryParam("postal", address.postalCode, this.conditionalQueryParam("countryCode", address.country, (WebTarget)webTarget))))));
    }

    private WebTarget conditionalQueryParam(String key, String value, WebTarget webTarget) {
        if (value == null || value.isEmpty()) {
            return webTarget;
        }
        return webTarget.queryParam(key, new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private GeocodingResponse get(Function<WebTarget, WebTarget> queryPrep) throws Route360ClientException {
        WebTarget target = queryPrep.apply(this.client.target(REST_URI).path(PATH_SINGLE_ADDRESS).queryParam("f", new Object[]{"json"}));
        if (!this.requestOptions.containsKey((Object)Option.MAX_LOCATIONS)) {
            target = target.queryParam(Option.MAX_LOCATIONS.name, new Object[]{1});
        }
        for (Map.Entry<Option, String> entry : this.requestOptions.entrySet()) {
            target = this.conditionalQueryParam(entry.getKey().name, entry.getValue(), target);
        }
        LOGGER.debug("Executing geocoding request to URI: " + target.getUri());
        try (Response response = target.request().buildGet().invoke();){
            GeocodingResponse geocodingResponse = this.validateResponse(response);
            return geocodingResponse;
        }
    }

    public GeocodingResponse[] getBatchParallel(int parallelThreads, int triesBeforeFail, String ... addresses) throws Route360ClientException {
        return this.getBatchParallel(this::get, parallelThreads, triesBeforeFail, addresses);
    }

    public GeocodingResponse[] getBatchParallel(int parallelThreads, int triesBeforeFail, Address ... addresses) throws Route360ClientException {
        return this.getBatchParallel(this::get, parallelThreads, triesBeforeFail, addresses);
    }

    private <A> GeocodingResponse[] getBatchParallel(GetRequest<A, GeocodingResponse> singleRequest, int parallelThreads, int triesBeforeFail, A[] addresses) throws Route360ClientException {
        if (parallelThreads < 1) {
            throw new Route360ClientRuntimeException("The number of specified threads has to be equal or greater than one.");
        }
        if (triesBeforeFail < 1) {
            throw new Route360ClientRuntimeException("The number of specified tries has to be equal or greater than one.");
        }
        if (addresses == null || addresses.length == 0) {
            throw new Route360ClientRuntimeException("The addresses array has to be not null and contain at least one element.");
        }
        ExecutorService executor = Executors.newFixedThreadPool(parallelThreads);
        ArrayList<Callable<GeocodingResponse>> requests = new ArrayList<Callable<GeocodingResponse>>();
        for (Object singleAddress : addresses) {
            requests.add(() -> {
                for (int numberOfTries = 0; numberOfTries < triesBeforeFail; ++numberOfTries) {
                    try {
                        return (GeocodingResponse)singleRequest.get(singleAddress);
                    }
                    catch (ServiceUnavailableException serviceUnavailableException) {
                        continue;
                    }
                }
                throw new ServiceUnavailableException("Even after " + triesBeforeFail + " tries the service was still unavailable. Try reducing the thread number or increasing the number of tries.");
            });
        }
        try {
            List results = executor.invokeAll(requests);
            this.shutdownServiceExecutor(executor);
            GeocodingResponse[] resultArray = new GeocodingResponse[addresses.length];
            int i = 0;
            for (Future result : results) {
                resultArray[i++] = (GeocodingResponse)result.get();
            }
            return resultArray;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Route360ClientException("Parallel Execution Failed! Cause: ", e);
        }
    }

    private void shutdownServiceExecutor(ExecutorService executor) throws InterruptedException {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(800L, TimeUnit.MILLISECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw e;
        }
    }

    public GeocodingResponse[] getBatchSequential(String ... addresses) throws Route360ClientException {
        return this.getBatchSequential(this::get, addresses);
    }

    public GeocodingResponse[] getBatchSequential(Address ... addresses) throws Route360ClientException {
        return this.getBatchSequential(this::get, addresses);
    }

    private <A> GeocodingResponse[] getBatchSequential(GetRequest<A, GeocodingResponse> singleRequest, A[] addresses) throws Route360ClientException {
        if (addresses == null || addresses.length == 0) {
            throw new Route360ClientException("The addresses array has to be not null and contain at least one element.");
        }
        GeocodingResponse[] batchResults = new GeocodingResponse[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            batchResults[i] = singleRequest.get(addresses[i]);
        }
        return batchResults;
    }

    private GeocodingResponse validateResponse(Response response) throws Route360ClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String jsonString = (String)response.readEntity(String.class);
            GeocodingResponse ret = (GeocodingResponse)JSON_PARSER.fromJson(jsonString, GeocodingResponse.class);
            return GeocodingResponse.createWithJson(ret, jsonString);
        }
        if (response.getStatus() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
            throw new ServiceUnavailableException();
        }
        throw new Route360ClientException("Request failed with response: \n" + (String)response.readEntity(String.class));
    }

    public static enum Option {
        SOURCE_COUNTRY("sourceCountry"),
        SEARCH_EXTENT("searchExtent"),
        CLOSE_LOCATION("location"),
        SPATIAL_REFERENCE("outSR"),
        MAX_LOCATIONS("maxLocations"),
        FOR_STORAGE("forStorage");

        private String name;

        private Option(String repName) {
            this.name = repName;
        }
    }
}

