/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.request;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.request.config.RequestConfigurator;
import net.motionintelligence.client.api.response.PointOfInterestResponse;
import net.motionintelligence.client.api.util.IOUtil;
import net.motionintelligence.client.api.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointOfInterestRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointOfInterestRequest.class);
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public PointOfInterestRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public PointOfInterestRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public PointOfInterestResponse get() throws Route360ClientException {
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getPointOfInterestServiceUrl()).path("/reachability").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        Entity entity = Entity.entity((Object)RequestConfigurator.getConfig(this.travelOptions), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug(String.format("Executing reachability request to URI: '%s'", target.getUri()));
        Response response = target.request().post(entity);
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateResponse(response, requestStart, roundTripTime);
    }

    private PointOfInterestResponse validateResponse(Response response, long requestStart, long roundTripTime) throws Route360ClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return new PointOfInterestResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart);
        }
        throw new Route360ClientException((String)response.readEntity(String.class), null);
    }
}

