/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.request;

import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.request.config.RequestConfigurator;
import net.motionintelligence.client.api.response.TimeResponse;
import net.motionintelligence.client.api.util.IOUtil;
import net.motionintelligence.client.api.util.JsonUtil;

public class TimeRequest {
    private static final String CALLBACK = "callback";
    private Client client;
    private TravelOptions travelOptions;

    public TimeRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public TimeRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public TimeResponse get() throws Route360ClientException, ProcessingException {
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getServiceUrl()).path("v1/time").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        String config = RequestConfigurator.getConfig(this.travelOptions);
        Response response = target.request().post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        long roundTripTime = System.currentTimeMillis() - requestStart;
        return this.validateResponse(response, requestStart, roundTripTime);
    }

    private TimeResponse validateResponse(Response response, long requestStart, long roundTripTime) throws Route360ClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String res = IOUtil.getResultString(response);
            return new TimeResponse(this.travelOptions, JsonUtil.parseString(res), requestStart);
        }
        if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
            return new TimeResponse(this.travelOptions, "gateway-time-out", roundTripTime, requestStart);
        }
        throw new Route360ClientException((String)response.readEntity(String.class), null);
    }
}

