/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.response;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.motionintelligence.client.api.geo.DefaultTargetCoordinate;
import net.motionintelligence.client.api.util.POJOUtil;

public class GeocodingResponse
implements Iterable<Candidate> {
    private final List<Candidate> candidates;
    private final String completeJsonResponse;

    private GeocodingResponse(List<Candidate> candidates, String jsonString) {
        this.completeJsonResponse = jsonString;
        this.candidates = candidates;
    }

    public static GeocodingResponse createWithJson(GeocodingResponse response, String jsonString) {
        return new GeocodingResponse(response.candidates, jsonString);
    }

    public String getCompleteJsonResponseAsString() {
        return this.completeJsonResponse;
    }

    public DefaultTargetCoordinate getRepresentativeGeocodeOfRequest() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            throw new NoSuchElementException("This response does not contain a coordination candidate.");
        }
        Candidate mostLikelyCandidate = this.candidates.get(0);
        return mostLikelyCandidate.getLocation();
    }

    public Candidate getRepresentativeCandidate() {
        if (this.candidates == null || this.candidates.isEmpty()) {
            throw new NoSuchElementException("This response does not contain a candidate.");
        }
        return this.candidates.get(0);
    }

    public String toString() {
        return POJOUtil.prettyPrintPOJO(this);
    }

    @Override
    public Iterator<Candidate> iterator() {
        return this.candidates.iterator();
    }

    public boolean isEmpty() {
        return this.candidates == null || this.candidates.isEmpty();
    }

    public class Candidate {
        private final double score;
        private final DefaultTargetCoordinate location;

        private Candidate(double score, DefaultTargetCoordinate df) {
            this.score = score;
            this.location = df;
        }

        public double getScore() {
            return this.score;
        }

        public DefaultTargetCoordinate getLocation() {
            return this.location;
        }
    }
}

