/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.response;

import java.util.HashMap;
import java.util.Map;
import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.exception.Route360ClientRuntimeException;
import net.motionintelligence.client.api.geo.Coordinate;
import net.motionintelligence.client.api.util.JsonUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class TimeResponse {
    private final String code;
    private final long requestTimeMillis;
    private final long totalTimeMillis;
    private final TravelOptions travelOptions;
    private final Map<Coordinate, Map<Coordinate, Integer>> travelTimes = new HashMap<Coordinate, Map<Coordinate, Integer>>();

    public TimeResponse(TravelOptions travelOptions, JSONObject result, long requestStart) {
        this.travelOptions = travelOptions;
        this.code = JsonUtil.getString(result, "code");
        this.requestTimeMillis = result.has("requestTime") ? JsonUtil.getLong(result, "requestTime") : -1L;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        this.mapResults(result);
    }

    public TimeResponse(TravelOptions travelOptions, String code, long requestTime, long requestStart) {
        this.travelOptions = travelOptions;
        this.code = code;
        this.requestTimeMillis = requestTime;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
    }

    public void mapResults(JSONObject result) {
        if (this.travelOptions == null) {
            throw new Route360ClientRuntimeException("Unsupported call");
        }
        this.mapResults(this.travelOptions, result);
    }

    public void mapResults(TravelOptions travelOptions, JSONObject result) {
        JSONArray jsonArray = JsonUtil.getJsonArray(result, "data");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject source = JsonUtil.getJSONObject(jsonArray, i);
            String srcId = JsonUtil.getString(source, "id");
            JSONArray targets = JsonUtil.getJsonArray(source, "targets");
            this.travelTimes.putIfAbsent(travelOptions.getSource(srcId), new HashMap());
            for (int j = 0; j < targets.length(); ++j) {
                JSONObject target = JsonUtil.getJSONObject(targets, j);
                String trgId = JsonUtil.getString(target, "id");
                this.addTravelTime(travelOptions.getSource(srcId), travelOptions.getTarget(trgId), JsonUtil.getInt(target, "travelTime"));
            }
        }
    }

    public void addTravelTime(Coordinate source, Coordinate target, Integer travelTime) {
        this.travelTimes.putIfAbsent(source, new HashMap());
        this.travelTimes.get(source).put(target, travelTime);
    }

    public Integer getTravelTime(Coordinate source, Coordinate target) {
        return ((Map)this.travelTimes.getOrDefault(source, null)).getOrDefault(target, -1);
    }

    public String getCode() {
        return this.code;
    }

    public long getRequestTimeMillis() {
        return this.requestTimeMillis;
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public Map<Coordinate, Map<Coordinate, Integer>> getTravelTimes() {
        return this.travelTimes;
    }

    public long getTotalTime() {
        return this.totalTimeMillis;
    }
}

