/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab;

import java.net.URI;
import java.util.Collection;
import net.nemerosa.ontrack.extension.gitlab.GitLabExtensionFeature;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.gitlab.service.GitLabConfigurationService;
import net.nemerosa.ontrack.extension.support.AbstractExtensionController;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.ExtensionFeatureDescription;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.ConnectionResult;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"extension/gitlab"})
public class GitLabController
extends AbstractExtensionController<GitLabExtensionFeature> {
    private final GitLabConfigurationService configurationService;
    private final SecurityService securityService;

    @Autowired
    public GitLabController(GitLabExtensionFeature feature, GitLabConfigurationService configurationService, SecurityService securityService) {
        super((ExtensionFeature)feature);
        this.configurationService = configurationService;
        this.securityService = securityService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resource<ExtensionFeatureDescription> getDescription() {
        return (Resource)Resource.of((Object)((GitLabExtensionFeature)this.feature).getFeatureDescription(), (URI)this.uri(((GitLabController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getDescription())).with("configurations", this.uri(((GitLabController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations()), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations"}, method={RequestMethod.GET})
    public Resources<GitLabConfiguration> getConfigurations() {
        return (Resources)((Resources)Resources.of((Collection)this.configurationService.getConfigurations(), (URI)this.uri(((GitLabController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations())).with("_create", this.uri(((GitLabController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationForm()))).with("_test", this.uri(((GitLabController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).testConfiguration(null)), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations/test"}, method={RequestMethod.POST})
    public ConnectionResult testConfiguration(@RequestBody GitLabConfiguration configuration) {
        return this.configurationService.test(configuration);
    }

    @RequestMapping(value={"configurations/descriptors"}, method={RequestMethod.GET})
    public Resources<ConfigurationDescriptor> getConfigurationsDescriptors() {
        return Resources.of((Collection)this.configurationService.getConfigurationDescriptors(), (URI)this.uri(((GitLabController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationsDescriptors()));
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.GET})
    public Form getConfigurationForm() {
        return GitLabConfiguration.form();
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.POST})
    public GitLabConfiguration newConfiguration(@RequestBody GitLabConfiguration configuration) {
        return (GitLabConfiguration)this.configurationService.newConfiguration(configuration);
    }

    @RequestMapping(value={"configurations/{name:.*}"}, method={RequestMethod.GET})
    public GitLabConfiguration getConfiguration(@PathVariable String name) {
        return (GitLabConfiguration)this.configurationService.getConfiguration(name);
    }

    @RequestMapping(value={"configurations/{name:.*}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Ack deleteConfiguration(@PathVariable String name) {
        this.configurationService.deleteConfiguration(name);
        return Ack.OK;
    }

    @RequestMapping(value={"configurations/{name:.*}/update"}, method={RequestMethod.GET})
    public Form updateConfigurationForm(@PathVariable String name) {
        return ((GitLabConfiguration)this.configurationService.getConfiguration(name)).asForm();
    }

    @RequestMapping(value={"configurations/{name:.*}/update"}, method={RequestMethod.PUT})
    public GitLabConfiguration updateConfiguration(@PathVariable String name, @RequestBody GitLabConfiguration configuration) {
        this.configurationService.updateConfiguration(name, configuration);
        return this.getConfiguration(name);
    }
}

