/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nemerosa.ontrack.extension.gitlab.GitLabExtensionFeature;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClient;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientFactory;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueWrapper;
import net.nemerosa.ontrack.extension.gitlab.service.GitLabConfigurationService;
import net.nemerosa.ontrack.extension.issues.export.IssueExportServiceFactory;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.support.AbstractIssueServiceExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.support.MessageAnnotation;
import net.nemerosa.ontrack.model.support.MessageAnnotator;
import net.nemerosa.ontrack.model.support.RegexMessageAnnotator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GitLabIssueServiceExtension
extends AbstractIssueServiceExtension {
    public static final String GITLAB_SERVICE_ID = "gitlab";
    private static final String GITLAB_ISSUE_PATTERN = "#(\\d+)";
    private final GitLabConfigurationService configurationService;
    private final OntrackGitLabClientFactory gitLabClientFactory;

    protected GitLabIssueServiceExtension(GitLabExtensionFeature extensionFeature, IssueExportServiceFactory issueExportServiceFactory, GitLabConfigurationService configurationService, OntrackGitLabClientFactory gitLabClientFactory) {
        super((ExtensionFeature)extensionFeature, GITLAB_SERVICE_ID, "GitLab", issueExportServiceFactory);
        this.configurationService = configurationService;
        this.gitLabClientFactory = gitLabClientFactory;
    }

    public List<? extends IssueServiceConfiguration> getConfigurationList() {
        return Collections.emptyList();
    }

    public IssueServiceConfiguration getConfigurationByName(String name) {
        String[] tokens = StringUtils.split((String)name, (String)":");
        if (tokens == null || tokens.length != 2) {
            throw new IllegalStateException("The GitLab issue configuration identifier name is expected using configuration:repository as a format");
        }
        String configuration = tokens[0];
        String repository = tokens[1];
        return new GitLabIssueServiceConfiguration((GitLabConfiguration)this.configurationService.getConfiguration(configuration), repository);
    }

    public boolean validIssueToken(String token) {
        return Pattern.matches(GITLAB_ISSUE_PATTERN, token);
    }

    public Set<String> extractIssueKeysFromMessage(IssueServiceConfiguration issueServiceConfiguration, String message) {
        HashSet<String> result = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            Matcher matcher = Pattern.compile(GITLAB_ISSUE_PATTERN).matcher(message);
            while (matcher.find()) {
                String issueKey = matcher.group(1);
                result.add(issueKey);
            }
        }
        return result;
    }

    public Optional<MessageAnnotator> getMessageAnnotator(IssueServiceConfiguration issueServiceConfiguration) {
        GitLabIssueServiceConfiguration configuration = (GitLabIssueServiceConfiguration)issueServiceConfiguration;
        return Optional.of(new RegexMessageAnnotator(GITLAB_ISSUE_PATTERN, key -> MessageAnnotation.of((String)"a").attr("href", String.format("%s/%s/issues/%s", configuration.getConfiguration().getUrl(), configuration.getRepository(), key.substring(1))).text(key)));
    }

    public String getLinkForAllIssues(IssueServiceConfiguration issueServiceConfiguration, List<Issue> issues) {
        return null;
    }

    public Issue getIssue(IssueServiceConfiguration issueServiceConfiguration, String issueKey) {
        GitLabIssueServiceConfiguration configuration = (GitLabIssueServiceConfiguration)issueServiceConfiguration;
        OntrackGitLabClient client = this.gitLabClientFactory.create(configuration.getConfiguration());
        return client.getIssue(configuration.getRepository(), this.getIssueId(issueKey));
    }

    public Optional<String> getIssueId(IssueServiceConfiguration issueServiceConfiguration, String token) {
        if (StringUtils.isNumeric((CharSequence)token) || this.validIssueToken(token)) {
            return Optional.of(String.valueOf(this.getIssueId(token)));
        }
        return Optional.empty();
    }

    public String getDisplayKey(IssueServiceConfiguration issueServiceConfiguration, String key) {
        if (key.startsWith("#")) {
            return key;
        }
        return "#" + key;
    }

    protected int getIssueId(String token) {
        return Integer.parseInt(StringUtils.stripStart((String)token, (String)"#"), 10);
    }

    protected Set<String> getIssueTypes(IssueServiceConfiguration issueServiceConfiguration, Issue issue) {
        GitLabIssueWrapper wrapper = (GitLabIssueWrapper)issue;
        return new HashSet<String>(wrapper.getLabels());
    }
}

