/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.service;

import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClient;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientFactory;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.gitlab.service.GitLabConfigurationService;
import net.nemerosa.ontrack.extension.support.AbstractConfigurationService;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventPostService;
import net.nemerosa.ontrack.model.security.EncryptionService;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogService;
import net.nemerosa.ontrack.model.support.ConfigurationRepository;
import net.nemerosa.ontrack.model.support.ConnectionResult;
import net.nemerosa.ontrack.model.support.OntrackConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GitLabConfigurationServiceImpl
extends AbstractConfigurationService<GitLabConfiguration>
implements GitLabConfigurationService {
    private final OntrackGitLabClientFactory gitLabClientFactory;
    private final ApplicationLogService applicationLogService;

    @Autowired
    public GitLabConfigurationServiceImpl(ConfigurationRepository configurationRepository, SecurityService securityService, EncryptionService encryptionService, EventPostService eventPostService, EventFactory eventFactory, OntrackGitLabClientFactory gitLabClientFactory, OntrackConfigProperties ontrackConfigProperties, ApplicationLogService applicationLogService) {
        super(GitLabConfiguration.class, configurationRepository, securityService, encryptionService, eventPostService, eventFactory, ontrackConfigProperties);
        this.gitLabClientFactory = gitLabClientFactory;
        this.applicationLogService = applicationLogService;
    }

    protected GitLabConfiguration injectCredentials(GitLabConfiguration configuration) {
        return configuration;
    }

    protected ConnectionResult validate(GitLabConfiguration configuration) {
        try {
            OntrackGitLabClient client = this.gitLabClientFactory.create(configuration);
            client.getRepositories();
            return ConnectionResult.ok();
        }
        catch (Exception ex) {
            this.applicationLogService.log(ApplicationLogEntry.error((Throwable)ex, (NameDescription)NameDescription.nd((String)"gitlab", (String)"GitLab connection issue"), (String)configuration.getUrl()).withDetail("gitlab-config-name", configuration.getName()).withDetail("gitlab-config-url", configuration.getUrl()));
            return ConnectionResult.error((String)ex.getMessage());
        }
    }
}

