/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientFactory;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.support.ConfigurationConnectorStatusIndicator;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import net.nemerosa.ontrack.model.support.Connector;
import net.nemerosa.ontrack.model.support.ConnectorDescription;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0002H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lnet/nemerosa/ontrack/extension/gitlab/GitLabConnectorStatusIndicator;", "Lnet/nemerosa/ontrack/extension/support/ConfigurationConnectorStatusIndicator;", "Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabConfiguration;", "configurationService", "Lnet/nemerosa/ontrack/model/support/ConfigurationService;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "gitLabClientFactory", "Lnet/nemerosa/ontrack/extension/gitlab/client/OntrackGitLabClientFactory;", "(Lnet/nemerosa/ontrack/model/support/ConfigurationService;Lnet/nemerosa/ontrack/model/security/SecurityService;Lnet/nemerosa/ontrack/extension/gitlab/client/OntrackGitLabClientFactory;)V", "type", "", "getType", "()Ljava/lang/String;", "connect", "", "config", "connectorDescription", "Lnet/nemerosa/ontrack/model/support/ConnectorDescription;", "ontrack-extension-gitlab"})
public class GitLabConnectorStatusIndicator
extends ConfigurationConnectorStatusIndicator<GitLabConfiguration> {
    @NotNull
    private final OntrackGitLabClientFactory gitLabClientFactory;
    @NotNull
    private final String type;

    public GitLabConnectorStatusIndicator(@NotNull ConfigurationService<GitLabConfiguration> configurationService, @NotNull SecurityService securityService, @NotNull OntrackGitLabClientFactory gitLabClientFactory) {
        Intrinsics.checkNotNullParameter(configurationService, (String)"configurationService");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)gitLabClientFactory, (String)"gitLabClientFactory");
        super(configurationService, securityService);
        this.gitLabClientFactory = gitLabClientFactory;
        this.type = "gitlab";
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    protected void connect(@NotNull GitLabConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        this.gitLabClientFactory.create(config).getRepositories();
    }

    @NotNull
    protected ConnectorDescription connectorDescription(@NotNull GitLabConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        return new ConnectorDescription(new Connector(this.getType(), config.getName()), config.getUrl());
    }
}

