/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.property;

import net.nemerosa.ontrack.extension.git.model.GitConfiguration;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.git.GitRepositoryAuthenticator;
import net.nemerosa.ontrack.git.UsernamePasswordGitRepositoryAuthenticator;
import org.jetbrains.annotations.Nullable;

public class GitLabGitConfiguration
implements GitConfiguration {
    public static final String CONFIGURATION_REPOSITORY_SEPARATOR = ":";
    private final GitLabProjectConfigurationProperty property;
    private final ConfiguredIssueService configuredIssueService;

    public GitLabGitConfiguration(GitLabProjectConfigurationProperty property, ConfiguredIssueService configuredIssueService) {
        this.property = property;
        this.configuredIssueService = configuredIssueService;
    }

    public String getType() {
        return "gitlab";
    }

    public String getName() {
        return this.property.getConfiguration().getName();
    }

    public GitLabProjectConfigurationProperty getProperty() {
        return this.property;
    }

    public String getRemote() {
        return String.format("%s/%s.git", this.property.getConfiguration().getUrl(), this.property.getRepository());
    }

    @Nullable
    public GitRepositoryAuthenticator getAuthenticator() {
        return new UsernamePasswordGitRepositoryAuthenticator(this.property.getConfiguration().getUser(), this.property.getConfiguration().getPassword());
    }

    public String getCommitLink() {
        return String.format("%s/%s/commit/{commit}", this.property.getConfiguration().getUrl(), this.property.getRepository());
    }

    public String getFileAtCommitLink() {
        return String.format("%s/%s/blob/{commit}/{path}", this.property.getConfiguration().getUrl(), this.property.getRepository());
    }

    public int getIndexationInterval() {
        return this.property.getIndexationInterval();
    }

    @Nullable
    public ConfiguredIssueService getConfiguredIssueService() {
        return this.configuredIssueService;
    }
}

