/*
 * Decompiled with CFR 0.152.
 */
package net.nuke24.tscript34.p0010.ducer;

import net.nuke24.tscript34.p0010.Function;
import net.nuke24.tscript34.p0010.ducer.DucerChunk;
import net.nuke24.tscript34.p0010.ducer.InputPortState;

public class DucerState<I, O> {
    public final Function<DucerChunk<I>, DucerState<I, O>> processor;
    public final InputPortState<I> input;
    public final DucerChunk<O> output;

    public DucerState(Function<DucerChunk<I>, DucerState<I, O>> processor, InputPortState<I> input, DucerChunk<O> output) {
        if (input.isClosed) assert (output.isEnd);
        this.processor = processor;
        this.input = input;
        this.output = output;
    }

    public DucerState<I, O> process(DucerChunk<I> input) {
        return this.processor.apply(input);
    }

    public boolean isDone() {
        return this.input.isClosed && this.output.isEnd;
    }

    public DucerState<I, O> closeInput() {
        return this.input.isClosed ? this : new DucerState<I, O>(this.processor, new InputPortState(true, this.input.queued), this.output);
    }

    public DucerState<I, O> closeOutput() {
        return this.output.isEnd ? this : new DucerState<I, O>(this.processor, this.input, new DucerChunk(this.output.payload, true));
    }

    public DucerState<I, O> close() {
        return this.closeOutput().closeInput();
    }
}

