/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.oauth2.AccessToken;

public class AccessTokenSerializer
extends StdSerializer<AccessToken> {
    private static final long serialVersionUID = 1L;

    protected AccessTokenSerializer(JavaType type) {
        super(type);
    }

    public void serialize(AccessToken token, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (token == null) {
            return;
        }
        Map map = null;
        try {
            map = token.map();
        }
        catch (Exception e) {
            provider.reportMappingProblem((Throwable)e, e.getMessage(), new Object[]{""});
        }
        MapType mapType = provider.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        TypeSerializer vts = provider.findTypeSerializer(provider.getTypeFactory().constructSimpleType(String.class, null));
        JsonSerializer keySer = provider.findKeySerializer(String.class, null);
        JsonSerializer valueSer = provider.findValueSerializer(Object.class);
        MapSerializer mapSerializer = MapSerializer.construct((Set)null, (JavaType)mapType, (boolean)false, (TypeSerializer)vts, (JsonSerializer)valueSer, (JsonSerializer)keySer, null);
        mapSerializer.serialize(map, gen, provider);
    }

    public static final SimpleModule REGISTER(SimpleModule module) {
        AccessTokenSerializer ser = new AccessTokenSerializer(TypeFactory.defaultInstance().constructSimpleType(AccessToken.class, null));
        module.addSerializer(ser.handledType(), (JsonSerializer)ser);
        return module;
    }
}

