/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;

public class WhitespaceDelimitedScopeSerializer
extends StdSerializer<Collection<String>> {
    private static final long serialVersionUID = -1463700179768817262L;
    private static final String SP = " ";
    private static final ToStringSerializer stringSerializer = ToStringSerializer.instance;

    protected WhitespaceDelimitedScopeSerializer(JavaType type) {
        super(type);
    }

    public void serialize(Collection<String> model, JsonGenerator jsonGen, SerializerProvider serializer) throws IOException, JsonProcessingException {
        if (model == null) {
            return;
        }
        StringBuilder scopesBuilder = new StringBuilder();
        model.stream().forEach(e -> scopesBuilder.append((String)e).append(SP));
        String scopeString = scopesBuilder.toString();
        scopeString = scopeString.trim();
        stringSerializer.serialize((Object)scopeString, jsonGen, serializer);
    }

    public static final SimpleModule REGISTER(SimpleModule module) {
        WhitespaceDelimitedScopeSerializer ser = new WhitespaceDelimitedScopeSerializer((JavaType)TypeFactory.defaultInstance().constructCollectionType(Collection.class, String.class));
        module.addSerializer(ser.handledType(), (JsonSerializer)ser);
        return module;
    }
}

