/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import net.oauth2.AccessToken;
import net.oauth2.ProtocolError;
import net.oauth2.client.http.DataBindingProvider;
import net.oauth2.jackson.OAuth2ObjectMapper;

public class JacksonDataBindingProvider
implements DataBindingProvider<ObjectMapper> {
    private static final ObjectMapper DEFAULT_MAPPER = new OAuth2ObjectMapper(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true));
    private ObjectMapper mapper;

    public JacksonDataBindingProvider() {
        this(DEFAULT_MAPPER);
    }

    public JacksonDataBindingProvider(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public <T extends AccessToken> T parseToken(String payload, Class<T> tokenType) throws JsonParseException, JsonMappingException, IOException {
        AccessToken token = (AccessToken)this.mapper.readValue(payload, tokenType);
        return (T)token;
    }

    public <T extends ProtocolError> T parseError(String payload, Class<T> errorType) throws JsonParseException, JsonMappingException, IOException {
        ProtocolError error = (ProtocolError)this.mapper.readValue(payload, errorType);
        return (T)error;
    }

    public ObjectMapper raw() {
        return this.mapper;
    }

    public void with(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }
}

