/*
 * Decompiled with CFR 0.152.
 */
package net.oauth2.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class WhitespaceDelimitedScopeDeserializer
extends StdDeserializer<Collection<String>> {
    private static final long serialVersionUID = 456504895806428666L;

    protected WhitespaceDelimitedScopeDeserializer(JavaType valueType) {
        super(valueType);
    }

    public WhitespaceDelimitedScopeDeserializer() {
        super((JavaType)TypeFactory.defaultInstance().constructCollectionType(Collection.class, String.class));
    }

    public Collection<String> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String enumerationStr = parser.getText();
        String[] enumerationArr = enumerationStr.split("\\s+");
        Collection<String> list = Collections.unmodifiableCollection(Arrays.asList(enumerationArr));
        return list;
    }

    public static final SimpleModule REGISTER(SimpleModule module) {
        CollectionType type = TypeFactory.defaultInstance().constructCollectionType(Collection.class, String.class);
        WhitespaceDelimitedScopeDeserializer deser = new WhitespaceDelimitedScopeDeserializer((JavaType)type);
        module.addDeserializer(Collection.class, (JsonDeserializer)deser);
        return module;
    }
}

