/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor;

import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import net.officefloor.eclipse.editor.AdaptedBuilderContext;
import net.officefloor.eclipse.editor.AdaptedEditorModule;
import net.officefloor.eclipse.editor.SelectOnly;
import net.officefloor.model.Model;

public abstract class AbstractEditorApplication
extends Application {
    private SelectOnly selectOnly = null;

    protected abstract void buildModels(AdaptedBuilderContext var1);

    protected abstract Model createRootModel();

    protected AdaptedEditorModule createModule() {
        return new AdaptedEditorModule();
    }

    protected void setSelectOnly(SelectOnly selectOnly) {
        this.selectOnly = selectOnly;
    }

    public void start(Stage stage) throws Exception {
        AdaptedEditorModule module = this.createModule();
        if (this.selectOnly != null) {
            module.setSelectOnly(this.selectOnly);
        }
        Pane parent = module.createParent(context -> this.buildModels(context));
        Scene scene = new Scene((Parent)parent);
        stage.setScene(scene);
        stage.setResizable(true);
        stage.setWidth(640.0);
        stage.setHeight(480.0);
        stage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        Model rootModel = this.createRootModel();
        module.activateDomain(rootModel);
        stage.show();
    }
}

