/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.multibindings.MapBinder;
import java.util.Arrays;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import net.officefloor.eclipse.editor.AdaptedBuilder;
import net.officefloor.eclipse.editor.AdaptedEditorPlugin;
import net.officefloor.eclipse.editor.SelectOnly;
import net.officefloor.eclipse.editor.internal.behaviors.PaletteFocusBehavior;
import net.officefloor.eclipse.editor.internal.handlers.CreateAdaptedConnectionOnDragHandler;
import net.officefloor.eclipse.editor.internal.handlers.CreateAdaptedParentOnDragHandler;
import net.officefloor.eclipse.editor.internal.models.ActiveConnectionSourceModel;
import net.officefloor.eclipse.editor.internal.models.ChangeExecutorImpl;
import net.officefloor.eclipse.editor.internal.parts.AdaptedAreaPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectionPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectorPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedParentPart;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorContentPartFactory;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorFocusFeedbackPartFactory;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorHoverFeedbackPartFactory;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorHoverIntentHandlePartFactory;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorSelectionFeedbackPartFactory;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorSelectionHandlePartFactory;
import net.officefloor.eclipse.editor.internal.parts.PaletteRootPart;
import net.officefloor.eclipse.editor.internal.policies.ContentRestrictedChangeViewportPolicy;
import net.officefloor.eclipse.editor.internal.style.StyleRegistry;
import net.officefloor.eclipse.editor.internal.views.ViewersComposite;
import net.officefloor.model.Model;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.inject.AdaptableScopes;
import org.eclipse.gef.common.adapt.inject.AdapterInjectionSupport;
import org.eclipse.gef.common.adapt.inject.AdapterMaps;
import org.eclipse.gef.mvc.fx.MvcFxModule;
import org.eclipse.gef.mvc.fx.behaviors.ContentPartPool;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.handlers.BendFirstAnchorageOnSegmentHandleDragHandler;
import org.eclipse.gef.mvc.fx.handlers.ConnectedSupport;
import org.eclipse.gef.mvc.fx.handlers.DeleteSelectedOnTypeHandler;
import org.eclipse.gef.mvc.fx.handlers.FocusAndSelectOnClickHandler;
import org.eclipse.gef.mvc.fx.handlers.HoverOnHoverHandler;
import org.eclipse.gef.mvc.fx.handlers.ResizeTransformSelectedOnHandleDragHandler;
import org.eclipse.gef.mvc.fx.handlers.ResizeTranslateFirstAnchorageOnHandleDragHandler;
import org.eclipse.gef.mvc.fx.handlers.RotateSelectedOnRotateHandler;
import org.eclipse.gef.mvc.fx.handlers.SelectAllOnTypeHandler;
import org.eclipse.gef.mvc.fx.handlers.SelectFocusedOnTypeHandler;
import org.eclipse.gef.mvc.fx.handlers.TranslateSelectedOnDragHandler;
import org.eclipse.gef.mvc.fx.handlers.TraverseFocusOnTypeHandler;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.CircleSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.DefaultHoverIntentHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.DefaultSelectionFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.DefaultSelectionHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IContentPartFactory;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.SquareSegmentHandlePart;
import org.eclipse.gef.mvc.fx.policies.BendConnectionPolicy;
import org.eclipse.gef.mvc.fx.policies.ResizePolicy;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;
import org.eclipse.gef.mvc.fx.providers.BoundsSnappingLocationProvider;
import org.eclipse.gef.mvc.fx.providers.CenterSnappingLocationProvider;
import org.eclipse.gef.mvc.fx.providers.DefaultAnchorProvider;
import org.eclipse.gef.mvc.fx.providers.GeometricOutlineProvider;
import org.eclipse.gef.mvc.fx.providers.ISnappingLocationProvider;
import org.eclipse.gef.mvc.fx.providers.ShapeBoundsProvider;
import org.eclipse.gef.mvc.fx.providers.TopLeftSnappingLocationProvider;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class AdaptedEditorModule
extends MvcFxModule {
    public static final String PALETTE_VIEWER_ROLE = "paletteViewer";
    private Injector injector;
    private IDomain domain;
    private IViewer content;
    private IViewer palette;
    private ViewersComposite viewersComposite;
    private SelectOnly selectOnly = null;
    private OfficeFloorContentPartFactory<?, ?> factory;

    public void setSelectOnly(SelectOnly selectOnly) {
        if (this.factory != null) {
            throw new IllegalStateException("May not configure " + SelectOnly.class.getSimpleName() + " after loading editor");
        }
        this.selectOnly = selectOnly;
    }

    public Pane createParent(AdaptedBuilder adaptedBuilder) {
        if (this.domain == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{this});
            IDomain domain = (IDomain)injector.getInstance(IDomain.class);
            this.initialise(domain, injector);
        }
        if (this.factory == null) {
            this.configure(adaptedBuilder);
        }
        return this.viewersComposite.getComposite();
    }

    public void activateDomain(Model rootModel) {
        this.loadRootModel(rootModel);
        this.domain.activate();
    }

    public void initialise(IDomain domain, Injector injector) {
        this.injector = injector;
        this.domain = domain;
        this.content = (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
        this.palette = (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)PALETTE_VIEWER_ROLE));
    }

    public void configure(AdaptedBuilder adaptedBuilder) {
        this.factory = (OfficeFloorContentPartFactory)this.injector.getInstance(OfficeFloorContentPartFactory.class);
        StyleRegistry styleRegistry = AdaptedEditorPlugin.createStyleRegistry();
        this.viewersComposite = new ViewersComposite(this.content, this.palette, this.selectOnly);
        ChangeExecutorImpl changeExecutor = new ChangeExecutorImpl(this.factory, this.domain);
        this.factory.init(this.injector, this.viewersComposite.getComposite(), this.content, this.viewersComposite.getPaletteIndicator(), this.palette, this.viewersComposite, changeExecutor, styleRegistry, this.selectOnly);
        adaptedBuilder.build(this.factory);
    }

    public IViewer getContentViewer() {
        return this.content;
    }

    public IViewer getPaletteViewer() {
        return this.palette;
    }

    public void loadRootModel(Model rootModel) {
        this.viewersComposite.init(this.factory.isCreateParent());
        this.viewersComposite.getComposite().applyCss();
        this.factory.loadRootModel(rootModel);
        this.viewersComposite.loadComplete();
    }

    protected void bindAbstractContentPartAdapters(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        super.bindAbstractContentPartAdapters(adapterMapBinder);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(FocusAndSelectOnClickHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(SelectFocusedOnTypeHandler.class);
    }

    protected void bindFocusFeedbackPartFactoryAsContentViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"FOCUS_FEEDBACK_PART_FACTORY")).to(OfficeFloorFocusFeedbackPartFactory.class);
    }

    protected void bindSelectionFeedbackPartFactoryAsContentViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_FEEDBACK_PART_FACTORY")).to(OfficeFloorSelectionFeedbackPartFactory.class);
    }

    protected void bindHoverFeedbackPartFactoryAsContentViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_FEEDBACK_PART_FACTORY")).to(OfficeFloorHoverFeedbackPartFactory.class);
    }

    protected void bindCircleSegmentHandlePartAdapters(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(BendFirstAnchorageOnSegmentHandleDragHandler.class);
    }

    protected void bindSquareSegmentHandlePartAdapters(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(ResizeTranslateFirstAnchorageOnHandleDragHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(ResizeTransformSelectedOnHandleDragHandler.class);
    }

    protected void bindContentPartPoolAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(ContentPartPool.class);
    }

    protected void bindContentRestrictedChangeViewportPolicyAsFXRootPartAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(ContentRestrictedChangeViewportPolicy.class);
    }

    protected void bindFocusFeedbackFactoryAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"FOCUS_FEEDBACK_PART_FACTORY")).to(OfficeFloorFocusFeedbackPartFactory.class);
    }

    protected void bindFocusModelAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(FocusModel.class);
    }

    protected void bindFXPaletteViewerAsFXDomainAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)PALETTE_VIEWER_ROLE)).to(IViewer.class);
    }

    protected void bindAdaptedConnectionInContentViewerContext(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(HoverOnHoverHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_FEEDBACK_GEOMETRY_PROVIDER")).to(GeometricOutlineProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_HANDLES_GEOMETRY_PROVIDER")).to(GeometricOutlineProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER")).to(GeometricOutlineProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_FEEDBACK_GEOMETRY_PROVIDER")).to(GeometricOutlineProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"FOCUS_FEEDBACK_GEOMETRY_PROVIDER")).to(GeometricOutlineProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(ResizePolicy.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(BendConnectionPolicy.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(TranslateSelectedOnDragHandler.class);
    }

    protected void bindAdaptedParentPartInPaletteViewerContext(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(HoverOnHoverHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(CreateAdaptedParentOnDragHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_FEEDBACK_GEOMETRY_PROVIDER")).to(ShapeBoundsProvider.class);
    }

    protected void bindHoverFeedbackFactoryAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_FEEDBACK_PART_FACTORY")).to(OfficeFloorHoverFeedbackPartFactory.class);
    }

    protected void bindHoverHandleFactoryAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_INTENT_HANDLE_PART_FACTORY")).to(DefaultHoverIntentHandlePartFactory.class);
    }

    protected void bindHoverHandlePartFactoryAsContentViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_INTENT_HANDLE_PART_FACTORY")).to(OfficeFloorHoverIntentHandlePartFactory.class);
    }

    protected void bindHoverModelAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(HoverModel.class);
    }

    protected void bindIContentPartFactory() {
        OfficeFloorContentPartFactory contentPartFactory = new OfficeFloorContentPartFactory();
        this.binder().bind(IContentPartFactory.class).toInstance(contentPartFactory);
        this.binder().bind(OfficeFloorContentPartFactory.class).toInstance(contentPartFactory);
    }

    protected void bindIContentPartFactoryAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(IContentPartFactory.class);
    }

    protected void bindIDomainAdapters(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        super.bindIDomainAdapters(adapterMapBinder);
        this.bindPaletteViewerAsDomainAdapter(adapterMapBinder);
    }

    protected void bindIRootPartAdaptersForContentViewer(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        super.bindIRootPartAdaptersForContentViewer(adapterMapBinder);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(DeleteSelectedOnTypeHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(RotateSelectedOnRotateHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(TraverseFocusOnTypeHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(SelectFocusedOnTypeHandler.class);
        this.bindSelectAllOnTypeHandlerAsContentViewerRootPartAdapter(adapterMapBinder);
    }

    protected void bindPaletteFocusBehaviorAsFXRootPartAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(PaletteFocusBehavior.class);
    }

    protected void bindPaletteRootPartAdaptersInPaletteViewerContext(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        this.bindHoverOnHoverHandlerAsIRootPartAdapter(adapterMapBinder);
        this.bindPanOrZoomOnScrollHandlerAsIRootPartAdapter(adapterMapBinder);
        this.bindPanOnTypeHandlerAsIRootPartAdapter(adapterMapBinder);
        this.bindContentRestrictedChangeViewportPolicyAsFXRootPartAdapter(adapterMapBinder);
        this.bindContentBehaviorAsIRootPartAdapter(adapterMapBinder);
        this.bindHoverBehaviorAsIRootPartAdapter(adapterMapBinder);
        this.bindPaletteFocusBehaviorAsFXRootPartAdapter(adapterMapBinder);
        this.bindFocusTraversalPolicyAsIRootPartAdapter(adapterMapBinder);
    }

    protected void bindPaletteRootPartAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)PALETTE_VIEWER_ROLE)).to(PaletteRootPart.class).in((Scope)AdaptableScopes.typed(IViewer.class));
    }

    protected void bindPaletteViewerAdapters(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        this.bindFocusModelAsPaletteViewerAdapter(adapterMapBinder);
        this.bindHoverModelAsPaletteViewerAdapter(adapterMapBinder);
        this.bindSelectionModelAsPaletteViewerAdapter(adapterMapBinder);
        this.bindPaletteRootPartAsPaletteViewerAdapter(adapterMapBinder);
        this.bindSelectionFeedbackFactoryAsPaletteViewerAdapter(adapterMapBinder);
        this.bindFocusFeedbackFactoryAsPaletteViewerAdapter(adapterMapBinder);
        this.bindHoverFeedbackFactoryAsPaletteViewerAdapter(adapterMapBinder);
        this.bindSelectionHandleFactoryAsPaletteViewerAdapter(adapterMapBinder);
        this.bindHoverHandleFactoryAsPaletteViewerAdapter(adapterMapBinder);
        this.bindContentPartPoolAsPaletteViewerAdapter(adapterMapBinder);
        this.bindIContentPartFactoryAsPaletteViewerAdapter(adapterMapBinder);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_FEEDBACK_COLOR_PROVIDER")).toInstance((Object)new Provider<Color>(){

            public Color get() {
                return Color.WHITE;
            }
        });
    }

    protected void bindPaletteViewerAsDomainAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)PALETTE_VIEWER_ROLE)).to(IViewer.class);
    }

    protected void bindSelectAllOnTypeHandlerAsContentViewerRootPartAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(SelectAllOnTypeHandler.class);
    }

    protected void bindSelectionFeedbackFactoryAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_FEEDBACK_PART_FACTORY")).to(DefaultSelectionFeedbackPartFactory.class);
    }

    protected void bindSelectionHandleFactoryAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_HANDLE_PART_FACTORY")).to(DefaultSelectionHandlePartFactory.class);
    }

    protected void bindSelectionHandlePartFactoryAsContentViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_HANDLE_PART_FACTORY")).to(OfficeFloorSelectionHandlePartFactory.class);
    }

    protected void bindSelectionModelAsPaletteViewerAdapter(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(SelectionModel.class);
    }

    protected void bindAdaptedParentInContentViewerContext(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(HoverOnHoverHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_FEEDBACK_GEOMETRY_PROVIDER")).to(ShapeBoundsProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"HOVER_INTENT_HANDLES_GEOMETRY_PROVIDER")).to(ShapeBoundsProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_FEEDBACK_GEOMETRY_PROVIDER")).toProvider((Provider)new Provider<ShapeBoundsProvider>(){

            public ShapeBoundsProvider get() {
                return new ShapeBoundsProvider(0.5);
            }
        });
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_HANDLES_GEOMETRY_PROVIDER")).toProvider((Provider)new Provider<ShapeBoundsProvider>(){

            public ShapeBoundsProvider get() {
                return new ShapeBoundsProvider(0.5);
            }
        });
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER")).to(GeometricOutlineProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"FOCUS_FEEDBACK_GEOMETRY_PROVIDER")).toProvider((Provider)new Provider<ShapeBoundsProvider>(){

            public ShapeBoundsProvider get() {
                return new ShapeBoundsProvider(0.5);
            }
        });
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(TranslateSelectedOnDragHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(TransformPolicy.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(ResizePolicy.class);
    }

    protected void bindAdaptedConnectorInContentViewerContext(MapBinder<AdapterKey<?>, Object> adapterMapBinder) {
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(DefaultAnchorProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(CreateAdaptedConnectionOnDragHandler.class);
        adapterMapBinder.addBinding((Object)AdapterKey.defaultRole()).to(ConnectedSupport.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SnapToGridSourceSnappingLocationProvider")).to(TopLeftSnappingLocationProvider.class);
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SnapToGeometrySourceSnappingLocationProvider")).toInstance((Object)ISnappingLocationProvider.union(Arrays.asList(new CenterSnappingLocationProvider(), new BoundsSnappingLocationProvider())));
        adapterMapBinder.addBinding((Object)AdapterKey.role((String)"SnapToGeometryTargetSnappingLocationProvider")).to(BoundsSnappingLocationProvider.class);
    }

    protected void configure() {
        super.configure();
        this.bindIContentPartFactory();
        this.bindAdaptedParentInContentViewerContext(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), AdaptedParentPart.class, (AdapterKey[])new AdapterKey[]{AdapterKey.get(IViewer.class, (String)"contentViewer")}));
        MapBinder areaBinder = AdapterMaps.getAdapterMapBinder((Binder)this.binder(), AdaptedAreaPart.class, (AdapterKey[])new AdapterKey[]{AdapterKey.get(IViewer.class, (String)"contentViewer")});
        this.bindAdaptedParentInContentViewerContext(areaBinder);
        this.bindAdaptedConnectorInContentViewerContext(areaBinder);
        this.bindAdaptedConnectorInContentViewerContext(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), AdaptedConnectorPart.class, (AdapterKey[])new AdapterKey[]{AdapterKey.get(IViewer.class, (String)"contentViewer")}));
        this.bindAdaptedConnectionInContentViewerContext(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), AdaptedConnectionPart.class, (AdapterKey[])new AdapterKey[]{AdapterKey.get(IViewer.class, (String)"contentViewer")}));
        ActiveConnectionSourceModel activeConnectionSource = new ActiveConnectionSourceModel();
        this.binder().bind(ActiveConnectionSourceModel.class).toInstance((Object)activeConnectionSource);
        this.bindSquareSegmentHandlePartAdapters(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), SquareSegmentHandlePart.class));
        this.bindCircleSegmentHandlePartAdapters(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), CircleSegmentHandlePart.class));
        this.bindPaletteViewerAdapters(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), IViewer.class, (AdapterKey[])new AdapterKey[]{AdapterKey.get(IViewer.class, (String)PALETTE_VIEWER_ROLE)}));
        this.bindPaletteRootPartAdaptersInPaletteViewerContext(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), IRootPart.class, (AdapterKey[])new AdapterKey[]{AdapterKey.get(IViewer.class, (String)PALETTE_VIEWER_ROLE)}));
        this.bindAdaptedParentPartInPaletteViewerContext(AdapterMaps.getAdapterMapBinder((Binder)this.binder(), AdaptedParentPart.class, (AdapterKey[])new AdapterKey[]{AdapterKey.get(IViewer.class, (String)PALETTE_VIEWER_ROLE)}));
    }

    protected void enableAdapterMapInjection() {
        this.install((Module)new AdapterInjectionSupport(AdapterInjectionSupport.LoggingMode.PRODUCTION));
    }
}

