/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Scene;
import net.officefloor.eclipse.editor.AdaptedEditorModule;
import net.officefloor.eclipse.editor.internal.style.OsgiStyleRegistry;
import net.officefloor.eclipse.editor.internal.style.OsgiURLStreamHandlerService;
import net.officefloor.eclipse.editor.internal.style.StyleRegistry;
import net.officefloor.eclipse.editor.internal.style.SystemStyleRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class AdaptedEditorPlugin
extends AbstractUIPlugin {
    private static AdaptedEditorPlugin INSTANCE;
    private static URL DEFAULT_STYLESHEET_URL;
    private ServiceRegistration<?> styleUrlHandler;

    public static StyleRegistry createStyleRegistry() {
        if (INSTANCE == null) {
            return new SystemStyleRegistry();
        }
        return new OsgiStyleRegistry();
    }

    public static String getDefaultStyleSheet() {
        InputStream defaultStyleSheet = AdaptedEditorModule.class.getResourceAsStream(String.valueOf(AdaptedEditorModule.class.getSimpleName()) + ".css");
        if (defaultStyleSheet == null) {
            throw new IllegalStateException("Default style sheet not available on class path");
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStreamReader reader = new InputStreamReader(defaultStyleSheet);){
                StringWriter stylesheet = new StringWriter();
                int character = ((Reader)reader).read();
                while (character != -1) {
                    stylesheet.write(character);
                    character = ((Reader)reader).read();
                }
                return stylesheet.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load default style sheet", ex);
        }
    }

    public static void loadDefaulStylesheet(Scene scene) {
        if (INSTANCE == null) {
            scene.getStylesheets().add((Object)(String.valueOf(AdaptedEditorModule.class.getName().replace('.', '/')) + ".css"));
            return;
        }
        if (DEFAULT_STYLESHEET_URL == null) {
            String styleSheet = AdaptedEditorPlugin.getDefaultStyleSheet();
            StyleRegistry registry = AdaptedEditorPlugin.createStyleRegistry();
            ReadOnlyProperty<URL> defaultStyleSheetUrl = registry.registerStyle("_default_", (ReadOnlyProperty<String>)new SimpleStringProperty(styleSheet));
            DEFAULT_STYLESHEET_URL = (URL)defaultStyleSheetUrl.getValue();
        }
        scene.getStylesheets().add((Object)DEFAULT_STYLESHEET_URL.toExternalForm());
    }

    public AdaptedEditorPlugin getDefault() {
        return INSTANCE;
    }

    public AdaptedEditorPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("url.handler.protocol", "officefloorstyle");
        this.styleUrlHandler = context.registerService(URLStreamHandlerService.class.getName(), (Object)new OsgiURLStreamHandlerService(), properties);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.styleUrlHandler != null) {
            context.ungetService(this.styleUrlHandler.getReference());
            this.styleUrlHandler = null;
        }
    }
}

