/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor;

import java.net.URL;
import javafx.scene.Node;
import javafx.scene.image.Image;
import net.officefloor.eclipse.editor.AdaptedActionVisualFactory;
import org.eclipse.gef.fx.nodes.HoverOverlayImageView;

public class DefaultImages {
    public static final String ADD_IMAGE = "add.png";
    public static final String ADD_IMAGE_HOVER = "add_hover.png";
    public static final AdaptedActionVisualFactory ADD = context -> context.createImageWithHover(DefaultImages.class, ADD_IMAGE, ADD_IMAGE_HOVER);
    public static final String EDIT_IMAGE = "edit.png";
    public static final String EDIT_IMAGE_HOVER = "edit_hover.png";
    public static final AdaptedActionVisualFactory EDIT = context -> context.createImageWithHover(DefaultImages.class, EDIT_IMAGE, EDIT_IMAGE_HOVER);
    public static final String DELETE_IMAGE = "delete.png";
    public static final String DELETE_IMAGE_HOVER = "delete_hover.png";
    public static final AdaptedActionVisualFactory DELETE = context -> context.createImageWithHover(DefaultImages.class, DELETE_IMAGE, DELETE_IMAGE_HOVER);

    public static Node createImageWithHover(Class<?> resourceClass, String imageFilePath, String hoverImageFilePath) {
        URL overlayImageResource = resourceClass.getResource(hoverImageFilePath);
        if (overlayImageResource == null) {
            throw new IllegalStateException("Cannot find resource " + hoverImageFilePath + " from resource class " + resourceClass.getName());
        }
        Image overlayImage = new Image(overlayImageResource.toExternalForm());
        URL baseImageResource = resourceClass.getResource(imageFilePath);
        if (baseImageResource == null) {
            throw new IllegalStateException("Cannot find resource " + imageFilePath + " from resource class " + resourceClass.getName());
        }
        Image baseImage = new Image(baseImageResource.toExternalForm());
        HoverOverlayImageView blendImageView = new HoverOverlayImageView();
        blendImageView.baseImageProperty().set((Object)baseImage);
        blendImageView.overlayImageProperty().set((Object)overlayImage);
        return blendImageView;
    }

    private DefaultImages() {
    }
}

