/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Map;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.internal.models.ProxyAdaptedConnection;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectablePart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectionPart;
import net.officefloor.model.Model;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.collections.ObservableMultiset;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.gestures.ClickDragGesture;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.CircleSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.DeletionPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class CreateAdaptedConnectionOnDragHandler<R extends Model, O>
extends AbstractHandler
implements IOnDragHandler {
    private AdaptedConnectablePart sourceConnector;
    private ProxyAdaptedConnection<R, O> connection;
    private AdaptedConnectionPart<R, O, ?> connectionPart;
    private CircleSegmentHandlePart bendTargetPart;
    private Map<AdapterKey<? extends IOnDragHandler>, IOnDragHandler> dragPolicies;

    protected AdaptedConnectablePart getAdaptedConnectablePart() {
        return (AdaptedConnectablePart)this.getHost();
    }

    protected Point getLocation(MouseEvent e) {
        if (this.getHost().getViewer() == null) {
            return new Point(e.getSceneX(), e.getSceneY());
        }
        Point2D location = ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(e.getSceneX(), e.getSceneY());
        return new Point(location.getX(), location.getY());
    }

    protected CircleSegmentHandlePart findBendTargetPart(AdaptedConnectionPart<R, O, ?> connectionPart, EventTarget eventTarget) {
        ObservableMultiset anchoreds = connectionPart.getAnchoredsUnmodifiable();
        for (IVisualPart anchored : anchoreds) {
            CircleSegmentHandlePart circleSegmentHandlePart;
            if (!(anchored instanceof CircleSegmentHandlePart) || (circleSegmentHandlePart = (CircleSegmentHandlePart)anchored).getSegmentParameter() != 1.0) continue;
            return circleSegmentHandlePart;
        }
        throw new IllegalStateException("Unable to obtain bend target part on creating new connection");
    }

    protected IViewer getContentViewer() {
        return (IViewer)this.getHost().getRoot().getViewer().getDomain().getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
    }

    protected void cleanupDrag() {
        this.restoreRefreshVisuals((IVisualPart)this.connectionPart);
        IRootPart contentRoot = this.getContentViewer().getRootPart();
        DeletionPolicy deletionPolicy = (DeletionPolicy)contentRoot.getAdapter(DeletionPolicy.class);
        this.init((IPolicy)deletionPolicy);
        deletionPolicy.delete(this.connectionPart);
        this.commit((IPolicy)deletionPolicy);
        this.sourceConnector.setActiveConnector(false);
        this.sourceConnector = null;
        this.connectionPart = null;
        this.bendTargetPart = null;
        this.dragPolicies = null;
    }

    public void startDrag(MouseEvent event) {
        AdaptedConnectablePart sourceConnectablePart = this.getAdaptedConnectablePart();
        if (!sourceConnectablePart.getContent().isAssociationCreateConnection()) {
            return;
        }
        if (sourceConnectablePart.getContent().getParentAdaptedConnectable().getSelectOnly() != null) {
            return;
        }
        this.sourceConnector = sourceConnectablePart;
        this.connection = new ProxyAdaptedConnection(this.sourceConnector.getContent());
        this.sourceConnector.setActiveConnector(true);
        CreationPolicy creationPolicy = (CreationPolicy)this.getHost().getRoot().getAdapter(CreationPolicy.class);
        this.init((IPolicy)creationPolicy);
        this.connectionPart = (AdaptedConnectionPart)creationPolicy.create(this.connection, (IVisualPart)this.getHost().getRoot(), (SetMultimap)HashMultimap.create());
        this.commit((IPolicy)creationPolicy);
        this.storeAndDisableRefreshVisuals((IVisualPart)this.connectionPart);
        ((Connection)this.connectionPart.getVisual()).setEndPoint(this.getLocation(event));
        ArrayList deselected = new ArrayList(((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable());
        deselected.remove(this.connectionPart);
        DeselectOperation deselectOperation = new DeselectOperation(this.getHost().getRoot().getViewer(), deselected);
        try {
            this.getHost().getRoot().getViewer().getDomain().execute((ITransactionalOperation)deselectOperation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.bendTargetPart = this.findBendTargetPart(this.connectionPart, event.getTarget());
        if (this.bendTargetPart != null) {
            this.dragPolicies = this.bendTargetPart.getAdapters(ClickDragGesture.ON_DRAG_POLICY_KEY);
        }
        if (this.dragPolicies != null) {
            MouseEvent dragEvent = new MouseEvent(event.getSource(), event.getTarget(), MouseEvent.MOUSE_DRAGGED, event.getX(), event.getY(), event.getScreenX(), event.getScreenY(), event.getButton(), event.getClickCount(), event.isShiftDown(), event.isControlDown(), event.isAltDown(), event.isMetaDown(), event.isPrimaryButtonDown(), event.isMiddleButtonDown(), event.isSecondaryButtonDown(), event.isSynthesized(), event.isPopupTrigger(), event.isStillSincePress(), event.getPickResult());
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.startDrag(event);
                dragPolicy.drag(dragEvent, new Dimension());
            }
        }
    }

    public void drag(MouseEvent event, Dimension delta) {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.drag(event, delta);
            }
        }
    }

    public void abortDrag() {
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.abortDrag();
            }
        }
        this.cleanupDrag();
    }

    public void endDrag(MouseEvent e, Dimension delta) {
        IBendableContentPart.BendPoint targetBendPoint;
        AdaptedConnector target;
        if (this.bendTargetPart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.endDrag(e, delta);
            }
        }
        if ((target = (AdaptedConnector)(targetBendPoint = this.connection.getTargetBendPoint()).getContentAnchorage()) != null) {
            AdaptedConnector<?> source = this.connection.getSourceAdaptedConnector();
            source.getParentAdaptedConnectable().createConnection(target.getParentAdaptedConnectable(), this.sourceConnector.getContent().getAssociationRole());
        }
        this.cleanupDrag();
    }

    public void hideIndicationCursor() {
    }

    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }
}

