/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import net.officefloor.eclipse.editor.AdaptedArea;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.editor.AdaptedConnectable;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedConnectorRole;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.AdaptedParent;
import net.officefloor.eclipse.editor.AdaptedPotentialConnection;
import net.officefloor.eclipse.editor.ChildrenGroup;
import net.officefloor.eclipse.editor.ModelAction;
import net.officefloor.eclipse.editor.SelectOnly;
import net.officefloor.eclipse.editor.internal.models.AdaptedPrototype;
import net.officefloor.eclipse.editor.internal.parts.AdaptedParentPart;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.gestures.ClickDragGesture;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.DeletionPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class CreateAdaptedParentOnDragHandler<R extends Model, O, M extends Model>
extends AbstractHandler
implements IOnDragHandler {
    private AdaptedPrototype<M> prototype;
    private AdaptedParentPart<M> prototypePart;
    private Map<AdapterKey<? extends IOnDragHandler>, IOnDragHandler> dragPolicies;

    protected IViewer getContentViewer() {
        return (IViewer)this.getHost().getRoot().getViewer().getDomain().getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
    }

    protected Point getLocation(MouseEvent e) {
        Point2D location = ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(e.getSceneX(), e.getSceneY());
        return new Point(location.getX(), location.getY());
    }

    protected void completeDrag(boolean isCreateAdaptedParent, MouseEvent event) {
        this.prototypePart.getErrorHandler().isError(() -> {
            Point location = this.getLocation(event);
            this.restoreRefreshVisuals((IVisualPart)this.prototypePart);
            IRootPart contentRoot = this.getContentViewer().getRootPart();
            DeletionPolicy deletionPolicy = (DeletionPolicy)contentRoot.getAdapter(DeletionPolicy.class);
            this.init((IPolicy)deletionPolicy);
            deletionPolicy.delete(this.prototypePart);
            this.commit((IPolicy)deletionPolicy);
            if (isCreateAdaptedParent) {
                this.prototype.newAdaptedParent(location);
            }
        });
        this.prototype = null;
        this.prototypePart = null;
        this.dragPolicies = null;
    }

    public AdaptedParentPart<M> getHost() {
        return (AdaptedParentPart)super.getHost();
    }

    public void startDrag(MouseEvent event) {
        AdaptedParentPart<M> parentPart = this.getHost();
        AdaptedParent parent = (AdaptedParent)parentPart.getContent();
        if (parent.getSelectOnly() != null) {
            return;
        }
        this.prototype = parentPart.getAdapter(AdaptedPrototype.class);
        if (this.prototype == null) {
            throw new IllegalStateException(String.valueOf(AdaptedParent.class.getSimpleName()) + " does not adapt to " + AdaptedPrototype.class.getSimpleName() + " for model " + parent.getModel().getClass().getName());
        }
        parentPart.getErrorHandler().isError(() -> {
            ProxyCreateAdaptedParent proxy = new ProxyCreateAdaptedParent(parent, this.prototype);
            IRootPart contentRoot = this.getContentViewer().getRootPart();
            CreationPolicy creationPolicy = (CreationPolicy)contentRoot.getAdapter(CreationPolicy.class);
            this.init((IPolicy)creationPolicy);
            this.prototypePart = (AdaptedParentPart)creationPolicy.create((Object)proxy, (IVisualPart)contentRoot, (SetMultimap)HashMultimap.create());
            this.commit((IPolicy)creationPolicy);
            this.storeAndDisableRefreshVisuals((IVisualPart)this.prototypePart);
            ArrayList deselected = new ArrayList(((SelectionModel)this.getContentViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable());
            deselected.remove(this.prototypePart);
            DeselectOperation deselectOperation = new DeselectOperation(this.getContentViewer(), deselected);
            try {
                this.getHost().getRoot().getViewer().getDomain().execute((ITransactionalOperation)deselectOperation, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            this.dragPolicies = this.prototypePart.getAdapters(ClickDragGesture.ON_DRAG_POLICY_KEY);
            if (this.dragPolicies != null) {
                for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                    dragPolicy.startDrag(event);
                }
            }
        });
    }

    public void drag(MouseEvent event, Dimension delta) {
        if (this.prototypePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.drag(event, delta);
            }
        }
    }

    public void abortDrag() {
        if (this.prototypePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.abortDrag();
            }
        }
        this.completeDrag(false, null);
    }

    public void endDrag(MouseEvent event, Dimension delta) {
        if (this.prototypePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.endDrag(event, delta);
            }
        }
        this.completeDrag(true, event);
    }

    public void hideIndicationCursor() {
    }

    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    private class ProxyCreateAdaptedParent
    implements AdaptedPrototype<M>,
    AdaptedParent<M> {
        private final AdaptedParent<M> parent;
        private final AdaptedPrototype<M> prototype;

        public ProxyCreateAdaptedParent(AdaptedParent<M> parent, AdaptedPrototype<M> prototype) {
            this.parent = parent;
            this.prototype = prototype;
        }

        @Override
        public void newAdaptedParent(Point location) {
            this.prototype.newAdaptedParent(location);
        }

        @Override
        public ReadOnlyProperty<String> getLabel() {
            return this.parent.getLabel();
        }

        @Override
        public Property<String> getEditLabel() {
            return null;
        }

        @Override
        public Property<String> getStylesheet() {
            return this.parent.getStylesheet();
        }

        @Override
        public ReadOnlyProperty<URL> getStylesheetUrl() {
            return this.parent.getStylesheetUrl();
        }

        @Override
        public List<AdaptedConnection<?>> getConnections() {
            return Collections.emptyList();
        }

        @Override
        public M getModel() {
            return this.parent.getModel();
        }

        @Override
        public AdaptedModel<?> getParent() {
            return this.parent.getParent();
        }

        @Override
        public List<AdaptedArea<?>> getAdaptedAreas() {
            return this.parent.getAdaptedAreas();
        }

        @Override
        public boolean isAreaChangeEvent(String eventName) {
            return this.parent.isAreaChangeEvent(eventName);
        }

        @Override
        public boolean isPalettePrototype() {
            return this.parent.isPalettePrototype();
        }

        @Override
        public void changeLocation(int x, int y) {
        }

        @Override
        public <T> T getAdapter(Class<T> classKey) {
            return this.parent.getAdapter(classKey);
        }

        @Override
        public List<ChildrenGroup<M, ?>> getChildrenGroups() {
            return this.parent.getChildrenGroups();
        }

        @Override
        public List<AdaptedConnector<M>> getAdaptedConnectors() {
            return this.parent.getAdaptedConnectors();
        }

        @Override
        public AdaptedConnector<M> getAdaptedConnector(Class<? extends ConnectionModel> connectionClass, AdaptedConnectorRole type) {
            return this.parent.getAdaptedConnector(connectionClass, type);
        }

        @Override
        public <T extends Model> AdaptedPotentialConnection getPotentialConnection(AdaptedConnectable<T> target) {
            return this.parent.getPotentialConnection(target);
        }

        @Override
        public <T extends Model> void createConnection(AdaptedConnectable<T> target, AdaptedConnectorRole sourceRole) {
            this.parent.createConnection(target, sourceRole);
        }

        @Override
        public Node createVisual(AdaptedChildVisualFactoryContext<M> context) {
            return this.parent.createVisual(context);
        }

        @Override
        public <r extends Model, o> void action(ModelAction<r, o, M> action) {
            this.parent.action(action);
        }

        @Override
        public AdaptedErrorHandler getErrorHandler() {
            return this.parent.getErrorHandler();
        }

        @Override
        public SelectOnly getSelectOnly() {
            return this.parent.getSelectOnly();
        }
    }
}

