/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import net.officefloor.eclipse.editor.AdaptedConnectable;
import net.officefloor.eclipse.editor.AdaptedConnectableBuilder;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.AdaptedConnectionBuilder;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedConnectorRole;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.AdaptedPotentialConnection;
import net.officefloor.eclipse.editor.ModelAction;
import net.officefloor.eclipse.editor.ModelActionContext;
import net.officefloor.eclipse.editor.OverlayVisualFactory;
import net.officefloor.eclipse.editor.SelectOnly;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedConnectionFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedConnectorImpl;
import net.officefloor.eclipse.editor.internal.models.ModelToConnection;
import net.officefloor.eclipse.editor.internal.models.ModelToSelfConnection;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorContentPartFactory;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;
import org.eclipse.gef.mvc.fx.parts.IContentPart;

public abstract class AbstractAdaptedConnectableFactory<R extends Model, O, M extends Model, E extends Enum<E>, A extends AdaptedModel<M>>
extends AbstractAdaptedFactory<R, O, M, E, A>
implements AdaptedConnectableBuilder<R, O, M, E> {
    protected final M modelPrototype;
    protected final Property<String> stylesheetContent = new SimpleStringProperty();
    protected final Map<Class<? extends ConnectionModel>, ModelToConnection<R, O, M, E, ? extends ConnectionModel>> connections = new HashMap<Class<? extends ConnectionModel>, ModelToConnection<R, O, M, E, ? extends ConnectionModel>>();
    protected final Map<ConnectionKey, AdaptedConnectionFactory<R, O, ?, ?, ?>> connectionFactories = new HashMap();
    protected ReadOnlyProperty<URL> stylesheetUrl;

    public AbstractAdaptedConnectableFactory(String configurationPathPrefix, M modelPrototype, Supplier<A> newAdaptedModel, AbstractAdaptedFactory<R, O, ?, ?, ?> parentAdaptedFactory) {
        super(configurationPathPrefix, modelPrototype.getClass(), newAdaptedModel, parentAdaptedFactory);
        this.modelPrototype = modelPrototype;
    }

    protected AbstractAdaptedConnectableFactory(String configurationPathPrefix, M modelPrototype, Supplier<A> newAdaptedModel, OfficeFloorContentPartFactory<R, O> contentPartFactory) {
        super(configurationPathPrefix, modelPrototype.getClass(), newAdaptedModel, contentPartFactory);
        this.modelPrototype = modelPrototype;
    }

    public void loadModelToConnection(Class<? extends ConnectionModel> connectionClass, ModelToConnection<R, O, ?, ?, ?> modelToConnection) {
        ModelToConnection<R, O, M, E, ? extends ConnectionModel> existing = this.connections.get(connectionClass);
        if (existing != null) {
            AdaptedConnectionFactory<R, O, ?, ?, ?> connectionFactory = modelToConnection.getAdaptedConnectionFactory();
            if (!(existing instanceof ModelToSelfConnection) && connectionFactory.getSourceModelClass() == connectionFactory.getTargetModelClass()) {
                this.connections.put(connectionClass, new ModelToSelfConnection<R, O, M, E, ConnectionModel>(existing, modelToConnection));
                return;
            }
            throw new IllegalStateException("Connection " + connectionClass.getName() + " already configured for model " + this.getModelClass().getName());
        }
        this.connections.put(connectionClass, modelToConnection);
    }

    @Override
    public void validate() throws IllegalStateException {
        ModelToConnection<R, O, M, E, ? extends ConnectionModel> connector;
        this.stylesheetUrl = this.getContentPartFactory().getStyleRegistry().registerStyle(this.getConfigurationPath(), (ReadOnlyProperty<String>)this.stylesheetContent);
        Enum firstEvent = null;
        for (Class<? extends ConnectionModel> connectionClass : this.connections.keySet()) {
            connector = this.connections.get(connectionClass);
            Enum[] events = connector.getConnectionChangeEvents();
            int i = 0;
            while (i < events.length) {
                Enum checkEvent = events[i];
                if (firstEvent == null) {
                    firstEvent = checkEvent;
                } else if (firstEvent.getDeclaringClass() != checkEvent.getDeclaringClass()) {
                    throw new IllegalStateException("Differing connection event enums for model " + this.getModelClass().getName() + " [" + firstEvent.name() + ", " + checkEvent.name() + "]");
                }
                ++i;
            }
        }
        for (Class<? extends ConnectionModel> connectionClass : this.connections.keySet()) {
            Class<?> targetModelClass;
            connector = this.connections.get(connectionClass);
            Class<?> sourceModelClass = connector.getAdaptedConnectionFactory().getSourceModelClass();
            ConnectionKey connectionKey = new ConnectionKey(sourceModelClass, targetModelClass = connector.getAdaptedConnectionFactory().getTargetModelClass());
            AdaptedConnectionFactory<R, O, ?, ?, ?> connectionFactory = this.connectionFactories.get(connectionKey);
            if (connectionFactory != null) {
                throw new IllegalStateException("Ambiguous connection between " + sourceModelClass.getName() + " and " + targetModelClass.getName() + " for connections " + connectionClass.getName() + " and " + connectionFactory.getModelClass().getName());
            }
            connectionFactory = connector.getAdaptedConnectionFactory();
            this.connectionFactories.put(connectionKey, connectionFactory);
        }
        AdaptedModel<M> adaptedModel = this.getContentPartFactory().createAdaptedModel(this.modelPrototype, (AdaptedModel<?>)null);
        IContentPart<Node> contentPart = this.getContentPartFactory().createContentPart(adaptedModel, null);
        contentPart.setContent(adaptedModel);
        contentPart.getVisual();
    }

    @Override
    public Property<String> style() {
        return this.stylesheetContent;
    }

    @Override
    @SafeVarargs
    public final <C extends ConnectionModel> AdaptedConnectionBuilder<R, O, M, C, E> connectOne(Class<C> connectionClass, Function<M, C> getConnection, Function<C, M> getSource, E ... connectionChangeEvents) {
        return this.connectMany(connectionClass, model -> {
            ConnectionModel connection = (ConnectionModel)getConnection.apply(model);
            if (connection == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(connection);
        }, getSource, (Enum[])connectionChangeEvents);
    }

    @Override
    @SafeVarargs
    public final <C extends ConnectionModel> AdaptedConnectionBuilder<R, O, M, C, E> connectMany(Class<C> connectionClass, Function<M, List<C>> getConnections, Function<C, M> getSource, E ... connectionChangeEvents) {
        AdaptedConnectionFactory adaptedConnectionFactory = new AdaptedConnectionFactory(this.getConfigurationPath(), connectionClass, this.getModelClass(), getSource, this);
        this.loadModelToConnection(connectionClass, new ModelToConnection(getConnections, connectionChangeEvents, adaptedConnectionFactory));
        return adaptedConnectionFactory;
    }

    protected static abstract class AbstractAdaptedConnectable<R extends Model, O, M extends Model, E extends Enum<E>, A extends AdaptedConnectable<M>, F extends AbstractAdaptedConnectableFactory<R, O, M, E, A>>
    extends AbstractAdaptedFactory.AbstractAdaptedModel<R, O, M, E, A, F>
    implements AdaptedConnectable<M>,
    ModelActionContext<R, O, M> {
        private Map<ConnectorKey, AdaptedConnector<M>> connectors;

        protected AbstractAdaptedConnectable() {
        }

        protected AdaptedConnector<M> createAdaptedConnector(Class<? extends ConnectionModel> connectionClass, AdaptedConnectorRole role, ModelToConnection<R, O, M, E, ?> connector) {
            return new AdaptedConnectorImpl<R, O, M>(this, connectionClass, role, connector);
        }

        @Override
        protected void init() {
            this.connectors = new HashMap<ConnectorKey, AdaptedConnector<M>>(((AbstractAdaptedConnectableFactory)this.getFactory()).connections.size());
            ArrayList<Enum> connectionChangeEvents = new ArrayList<Enum>();
            for (Class<? extends ConnectionModel> connectionClass : ((AbstractAdaptedConnectableFactory)this.getFactory()).connections.keySet()) {
                ModelToConnection connector = ((AbstractAdaptedConnectableFactory)this.getFactory()).connections.get(connectionClass);
                if (connector instanceof ModelToSelfConnection) {
                    ModelToSelfConnection selfConnector = (ModelToSelfConnection)connector;
                    this.connectors.put(new ConnectorKey(connectionClass, AdaptedConnectorRole.SOURCE), this.createAdaptedConnector(connectionClass, AdaptedConnectorRole.SOURCE, selfConnector.getSourceToConnection()));
                    this.connectors.put(new ConnectorKey(connectionClass, AdaptedConnectorRole.TARGET), this.createAdaptedConnector(connectionClass, AdaptedConnectorRole.TARGET, selfConnector.getTargetToConnection()));
                } else {
                    this.connectors.put(new ConnectorKey(connectionClass, null), this.createAdaptedConnector(connectionClass, null, connector));
                }
                connectionChangeEvents.addAll(Arrays.asList(connector.getConnectionChangeEvents()));
            }
            if (connectionChangeEvents.size() > 0) {
                Enum[] events = (Enum[])Array.newInstance(((Enum)connectionChangeEvents.get(0)).getDeclaringClass(), connectionChangeEvents.size());
                int i = 0;
                while (i < events.length) {
                    events[i] = (Enum)connectionChangeEvents.get(i);
                    ++i;
                }
                this.registerEventListener(connectionChangeEvents.toArray(events), event -> this.refreshContent());
            }
        }

        @Override
        public List<AdaptedConnection<?>> getConnections() {
            ArrayList connections = new ArrayList();
            for (ModelToConnection modelToConnection : ((AbstractAdaptedConnectableFactory)this.getFactory()).connections.values()) {
                List<? extends ConnectionModel> connectionModels = modelToConnection.getConnections(this.getModel());
                for (ConnectionModel connectionModel : connectionModels) {
                    AdaptedConnection adaptedConnection = (AdaptedConnection)((AbstractAdaptedConnectableFactory)this.getFactory()).getContentPartFactory().createAdaptedModel(connectionModel, null);
                    connections.add(adaptedConnection);
                }
            }
            this.loadDescendantConnections(connections);
            return connections;
        }

        protected abstract void loadDescendantConnections(List<AdaptedConnection<?>> var1);

        @Override
        public Property<String> getStylesheet() {
            return ((AbstractAdaptedConnectableFactory)this.getFactory()).stylesheetContent;
        }

        @Override
        public ReadOnlyProperty<URL> getStylesheetUrl() {
            return ((AbstractAdaptedConnectableFactory)this.getFactory()).stylesheetUrl;
        }

        @Override
        public List<AdaptedConnector<M>> getAdaptedConnectors() {
            return new ArrayList<AdaptedConnector<M>>(this.connectors.values());
        }

        @Override
        public <T extends Model> AdaptedPotentialConnection getPotentialConnection(AdaptedConnectable<T> target) {
            return this.getConnectionFactory(target);
        }

        @Override
        public <T extends Model> void createConnection(AdaptedConnectable<T> target, AdaptedConnectorRole sourceRole) {
            for (AdaptedConnection<?> connection : this.getConnections()) {
                if (sourceRole == null) {
                    if (connection.getSource() != target && connection.getTarget() != target) continue;
                    return;
                }
                switch (sourceRole) {
                    case SOURCE: {
                        if (connection.getTarget() != target) break;
                        return;
                    }
                    case TARGET: {
                        if (connection.getSource() != target) break;
                        return;
                    }
                }
            }
            AdaptedConnectionFactory<R, O, T, T, T> connectionFactory = this.getConnectionFactory(target);
            if (connectionFactory == null) {
                return;
            }
            if (!connectionFactory.canCreateConnection()) {
                return;
            }
            Object sourceModel = this.getModel();
            Object targetModel = target.getModel();
            boolean isSwap = false;
            if (connectionFactory.getSourceModelClass().equals(connectionFactory.getTargetModelClass())) {
                if (AdaptedConnectorRole.TARGET.equals((Object)sourceRole)) {
                    isSwap = true;
                }
            } else if (sourceModel.getClass().equals(connectionFactory.getTargetModelClass())) {
                isSwap = true;
            }
            if (isSwap) {
                Object swap = sourceModel;
                sourceModel = targetModel;
                targetModel = swap;
            }
            connectionFactory.createConnection((Model)sourceModel, (Model)targetModel);
        }

        @Override
        public AdaptedConnector<M> getAdaptedConnector(Class<? extends ConnectionModel> connectionClass, AdaptedConnectorRole type) {
            AdaptedConnector<M> connector = this.connectors.get(new ConnectorKey(connectionClass, type));
            if (connector == null) {
                throw new IllegalStateException("No connector for connection " + connectionClass.getName() + " from model " + this.getModel().getClass().getName());
            }
            return connector;
        }

        private AdaptedConnectionFactory<R, O, ?, ?, ?> getConnectionFactory(AdaptedConnectable<?> target) {
            Class<?> sourceModelClass = this.getModel().getClass();
            Class<?> targetModelClass = target.getModel().getClass();
            ConnectionKey key = new ConnectionKey(sourceModelClass, targetModelClass);
            return ((AbstractAdaptedConnectableFactory)this.getFactory()).connectionFactories.get(key);
        }

        @Override
        public SelectOnly getSelectOnly() {
            return ((AbstractAdaptedConnectableFactory)this.getFactory()).getContentPartFactory().getSelectOnly();
        }

        @Override
        public AdaptedModel<M> getAdaptedModel() {
            return this;
        }

        @Override
        public void overlay(OverlayVisualFactory overlayVisualFactory) {
            Object model = this.getModel();
            ((AbstractAdaptedConnectableFactory)this.getFactory()).getContentPartFactory().overlay(model.getX(), model.getY(), overlayVisualFactory);
        }

        @Override
        public <r extends Model, o> void action(ModelAction<r, o, M> action) {
            if (((AbstractAdaptedConnectableFactory)this.getFactory()).getContentPartFactory().getSelectOnly() != null) {
                return;
            }
            this.getErrorHandler().isError(() -> action.execute(this));
        }

        private static class ConnectorKey {
            private final Class<? extends ConnectionModel> connectionClass;
            private final AdaptedConnectorRole type;

            private ConnectorKey(Class<? extends ConnectionModel> connectionClass, AdaptedConnectorRole type) {
                this.connectionClass = connectionClass;
                this.type = type;
            }

            public int hashCode() {
                return this.connectionClass.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof ConnectorKey)) {
                    return false;
                }
                ConnectorKey that = (ConnectorKey)obj;
                if (!this.connectionClass.equals(that.connectionClass)) {
                    return false;
                }
                if (this.type == null || that.type == null) {
                    return true;
                }
                return this.type.equals((Object)that.type);
            }
        }
    }

    private static class ConnectionKey {
        private final Class<?> sourceModelClass;
        private final Class<?> targetModelClass;

        public ConnectionKey(Class<?> sourceModelClass, Class<?> targetModelClass) {
            this.sourceModelClass = sourceModelClass;
            this.targetModelClass = targetModelClass;
        }

        public int hashCode() {
            return this.sourceModelClass.hashCode() + this.targetModelClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)obj;
            if (this.sourceModelClass.equals(that.sourceModelClass) && this.targetModelClass.equals(that.targetModelClass)) {
                return true;
            }
            return this.sourceModelClass.equals(that.targetModelClass) && this.targetModelClass.equals(that.sourceModelClass);
        }
    }
}

