/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import com.google.inject.Injector;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.function.Supplier;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.ChangeExecutor;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorContentPartFactory;
import net.officefloor.model.Model;

public abstract class AbstractAdaptedFactory<R extends Model, O, M extends Model, E extends Enum<E>, A extends AdaptedModel<M>> {
    private final String configurationPath;
    private final Class<M> modelClass;
    private final Supplier<A> newAdaptedModel;
    private final OfficeFloorContentPartFactory<R, O> contentPartFactory;
    private Injector injector;
    private Map<Class<?>, AbstractAdaptedFactory<R, O, ?, ?, ?>> modelFactories;

    public static <M extends Model, E extends Enum<E>> void registerEventListener(M model, E[] events, PropertyChangeListener listener) {
        model.addPropertyChangeListener(event -> {
            String eventName = event.getPropertyName();
            boolean isInterested = false;
            Enum[] enumArray2 = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                Enum labelChangeEvent = enumArray2[n2];
                if (labelChangeEvent.name().equals(eventName)) {
                    isInterested = true;
                    break;
                }
                ++n2;
            }
            if (!isInterested) {
                return;
            }
            listener.propertyChange(event);
        });
    }

    public AbstractAdaptedFactory(String configurationPathPrefix, Class<M> modelClass, Supplier<A> newAdaptedModel, OfficeFloorContentPartFactory<R, O> contentPartFactory) {
        this.configurationPath = String.valueOf("".equals(configurationPathPrefix) ? "" : String.valueOf(configurationPathPrefix) + ".") + modelClass.getSimpleName();
        this.modelClass = modelClass;
        this.newAdaptedModel = newAdaptedModel;
        this.contentPartFactory = contentPartFactory;
        this.contentPartFactory.registerModel(this);
    }

    public AbstractAdaptedFactory(String adaptedPathPrefix, Class<M> modelClass, Supplier<A> newAdaptedModel, AbstractAdaptedFactory<R, O, ?, ?, ?> parentAdaptedModel) {
        this(adaptedPathPrefix, modelClass, newAdaptedModel, parentAdaptedModel.contentPartFactory);
    }

    public Class<M> getModelClass() {
        return this.modelClass;
    }

    public void init(Injector injector, Map<Class<?>, AbstractAdaptedFactory<R, O, ?, ?, ?>> modelFactories) throws IllegalStateException {
        this.injector = injector;
        this.modelFactories = modelFactories;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    protected OfficeFloorContentPartFactory<R, O> getContentPartFactory() {
        return this.contentPartFactory;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    protected AbstractAdaptedFactory<?, ?, ?, ?, ?> getModelFactory(Class<?> modelClass) {
        return this.modelFactories.get(modelClass);
    }

    public void validate() throws IllegalStateException {
    }

    public <m extends Model> AdaptedModel<m> getAdaptedModel(m model, AdaptedModel<?> parentAdaptedModel) {
        return this.contentPartFactory.createAdaptedModel(model, parentAdaptedModel);
    }

    public final A newAdaptedModel(R rootModel, O operations, AdaptedModel<?> parentAdaptedModel, M model) {
        AdaptedModel adapted = (AdaptedModel)this.newAdaptedModel.get();
        AbstractAdaptedModel abstractAdapted = (AbstractAdaptedModel)adapted;
        abstractAdapted.factory = this;
        abstractAdapted.rootModel = rootModel;
        abstractAdapted.operations = operations;
        abstractAdapted.parentAdaptedModel = parentAdaptedModel;
        abstractAdapted.model = model;
        abstractAdapted.init();
        return (A)adapted;
    }

    protected static abstract class AbstractAdaptedModel<R extends Model, O, M extends Model, E extends Enum<E>, A extends AdaptedModel<M>, F extends AbstractAdaptedFactory<R, O, M, E, A>>
    implements AdaptedModel<M> {
        private AbstractAdaptedFactory<R, O, M, E, A> factory;
        private R rootModel;
        private O operations;
        private AdaptedModel<?> parentAdaptedModel;
        private M model;

        protected AbstractAdaptedModel() {
        }

        protected abstract void init();

        @Override
        public M getModel() {
            return this.model;
        }

        @Override
        public AdaptedModel<?> getParent() {
            return this.parentAdaptedModel;
        }

        @Override
        public AdaptedErrorHandler getErrorHandler() {
            return ((AbstractAdaptedFactory)this.getFactory()).getContentPartFactory().getErrorHandler();
        }

        protected F getFactory() {
            return (F)this.factory;
        }

        public R getRootModel() {
            return this.rootModel;
        }

        public O getOperations() {
            return this.operations;
        }

        public void refreshContent() {
            ((AbstractAdaptedFactory)this.getFactory()).getContentPartFactory().loadContentModels();
        }

        public Injector getInjector() {
            return ((AbstractAdaptedFactory)this.factory).injector;
        }

        public ChangeExecutor getChangeExecutor() {
            return ((AbstractAdaptedFactory)this.factory).contentPartFactory.getChangeExecutor();
        }

        public M position(M model) {
            model.setX(this.model.getX());
            model.setY(this.model.getY());
            return model;
        }

        protected void registerEventListener(E[] events, PropertyChangeListener listener) {
            AbstractAdaptedFactory.registerEventListener(this.model, events, (PropertyChangeListener)listener);
        }
    }
}

