/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.officefloor.eclipse.editor.AdaptedActionVisualFactory;
import net.officefloor.eclipse.editor.ModelAction;
import net.officefloor.eclipse.editor.ModelActionContext;
import net.officefloor.eclipse.editor.internal.models.AdaptedAction;
import net.officefloor.eclipse.editor.internal.models.AdaptedActions;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorContentPartFactory;
import net.officefloor.model.Model;

public class AdaptedActionsFactory<R extends Model, O, M extends Model> {
    private final OfficeFloorContentPartFactory<R, O> contentPartFactory;
    private final List<ModelToAction<R, O, M>> modelToActions = new LinkedList<ModelToAction<R, O, M>>();

    public AdaptedActionsFactory(OfficeFloorContentPartFactory<R, O> contentPartFactory) {
        this.contentPartFactory = contentPartFactory;
    }

    public void addAction(ModelAction<R, O, M> action, AdaptedActionVisualFactory visualFactory) {
        this.modelToActions.add(new ModelToAction(action, visualFactory));
    }

    public AdaptedActions<R, O, M> createAdaptedActions(ModelActionContext<R, O, M> actionContext) {
        if (this.modelToActions.size() == 0) {
            return null;
        }
        boolean isClickOnly = this.contentPartFactory.getSelectOnly() != null;
        ArrayList actions = new ArrayList(this.modelToActions.size());
        for (ModelToAction<R, O, M> action : this.modelToActions) {
            ModelAction modelAction = ((ModelToAction)action).action;
            if (isClickOnly) {
                modelAction = context -> {};
            }
            actions.add(new AdaptedAction(modelAction, actionContext, ((ModelToAction)action).visualFactory, this.contentPartFactory.getErrorHandler()));
        }
        return new AdaptedActions(actions);
    }

    private static class ModelToAction<R extends Model, O, M extends Model> {
        private final ModelAction<R, O, M> action;
        private final AdaptedActionVisualFactory visualFactory;

        private ModelToAction(ModelAction<R, O, M> action, AdaptedActionVisualFactory visualFactory) {
            this.action = action;
            this.visualFactory = visualFactory;
        }
    }
}

