/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.officefloor.eclipse.editor.AdaptedActionVisualFactory;
import net.officefloor.eclipse.editor.AdaptedArea;
import net.officefloor.eclipse.editor.AdaptedAreaBuilder;
import net.officefloor.eclipse.editor.AdaptedConnectable;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedConnectorRole;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.ModelAction;
import net.officefloor.eclipse.editor.ParentToAreaConnectionModel;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedConnectableFactory;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedActions;
import net.officefloor.eclipse.editor.internal.models.AdaptedActionsFactory;
import net.officefloor.eclipse.editor.internal.models.ModelToConnection;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;
import org.eclipse.gef.geometry.planar.Dimension;

public class AdaptedAreaFactory<R extends Model, O, M extends Model, E extends Enum<E>>
extends AbstractAdaptedConnectableFactory<R, O, M, E, AdaptedArea<M>>
implements AdaptedAreaBuilder<R, O, M, E> {
    private final Function<M, Dimension> getDimension;
    private final BiConsumer<M, Dimension> setDimension;
    private final AdaptedActionsFactory<R, O, M> actionsFactory;
    private Dimension minimumDimension = new Dimension(50.0, 50.0);

    public AdaptedAreaFactory(String adaptedPathPrefix, M modelPrototype, AbstractAdaptedFactory<R, O, ?, ?, ?> parentAdaptedFactory, Function<M, Dimension> getDimension, BiConsumer<M, Dimension> setDimension) {
        super(adaptedPathPrefix, modelPrototype, () -> new AdaptedAreaImpl(), parentAdaptedFactory);
        this.getDimension = getDimension;
        this.setDimension = setDimension;
        this.actionsFactory = new AdaptedActionsFactory(parentAdaptedFactory.getContentPartFactory());
    }

    @Override
    public void setMinimumDimension(double width, double height) {
        this.minimumDimension = new Dimension(width, height);
    }

    @Override
    public void action(ModelAction<R, O, M> action, AdaptedActionVisualFactory visualFactory) {
        this.actionsFactory.addAction(action, visualFactory);
    }

    public static class AdaptedAreaImpl<R extends Model, O, M extends Model, E extends Enum<E>>
    extends AbstractAdaptedConnectableFactory.AbstractAdaptedConnectable<R, O, M, E, AdaptedArea<M>, AdaptedAreaFactory<R, O, M, E>>
    implements AdaptedArea<M>,
    AdaptedConnector<M> {
        private ParentToAreaConnectionModel connectionModel = null;
        private AdaptedActions<R, O, M> actions = null;

        @Override
        protected void init() {
            super.init();
            AdaptedModel parent = this.getParent();
            if (parent != null) {
                Object parentModel = parent.getModel();
                Model areaModel = this.getModel();
                this.connectionModel = new ParentToAreaConnectionModel((Model)parentModel, areaModel);
            }
            this.actions = ((AdaptedAreaFactory)this.getFactory()).actionsFactory.createAdaptedActions(this);
        }

        @Override
        public <T> T getAdapter(Class<T> classKey) {
            if (AdaptedActions.class.equals(classKey)) {
                return (T)this.actions;
            }
            return null;
        }

        @Override
        public AdaptedConnector<M> getAdaptedConnector(Class<? extends ConnectionModel> connectionClass, AdaptedConnectorRole type) {
            if (!ParentToAreaConnectionModel.class.equals(connectionClass)) {
                throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " should only be connected via " + ParentToAreaConnectionModel.class.getName() + " (but was " + connectionClass.getName() + ")");
            }
            return this;
        }

        @Override
        public Dimension getMinimumDimension() {
            return ((AdaptedAreaFactory)this.getFactory()).minimumDimension;
        }

        @Override
        public Dimension getDimension() {
            return (Dimension)((AdaptedAreaFactory)this.getFactory()).getDimension.apply(this.getModel());
        }

        @Override
        public void setDimension(Dimension dimension) {
            ((AdaptedAreaFactory)this.getFactory()).setDimension.accept(this.getModel(), dimension);
        }

        @Override
        protected AdaptedConnector<M> createAdaptedConnector(Class<? extends ConnectionModel> connectionClass, AdaptedConnectorRole role, ModelToConnection<R, O, M, E, ?> connector) {
            return this;
        }

        @Override
        public ParentToAreaConnectionModel getParentConnection() {
            return this.connectionModel;
        }

        @Override
        protected void loadDescendantConnections(List<AdaptedConnection<?>> connections) {
        }

        @Override
        public AdaptedConnectable<M> getParentAdaptedConnectable() {
            return this;
        }

        @Override
        public Class<? extends ConnectionModel> getConnectionModelClass() {
            return ParentToAreaConnectionModel.class;
        }

        @Override
        public void setAssociation(List<AdaptedConnector<M>> associatedAdaptedConnectors, AdaptedConnectorRole associatedRole) {
        }

        @Override
        public boolean isAssociationCreateConnection() {
            return false;
        }

        @Override
        public AdaptedConnectorRole getAssociationRole() {
            return AdaptedConnectorRole.SOURCE;
        }
    }
}

