/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import net.officefloor.eclipse.editor.AdaptedChild;
import net.officefloor.eclipse.editor.AdaptedChildBuilder;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactory;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.ChildrenGroup;
import net.officefloor.eclipse.editor.ChildrenGroupBuilder;
import net.officefloor.eclipse.editor.SelectOnly;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedConnectableFactory;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedFactory;
import net.officefloor.eclipse.editor.internal.models.ChildrenGroupFactory;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorContentPartFactory;
import net.officefloor.model.Model;
import net.officefloor.model.change.Change;
import net.officefloor.model.change.Conflict;

public class AdaptedChildFactory<R extends Model, O, M extends Model, E extends Enum<E>, A extends AdaptedChild<M>>
extends AbstractAdaptedConnectableFactory<R, O, M, E, A>
implements AdaptedChildBuilder<R, O, M, E> {
    private final AdaptedChildVisualFactory<M> viewFactory;
    private Function<M, String> getLabel = null;
    private AdaptedChildBuilder.LabelChange<M> setLabel = null;
    private E[] labelEvents = null;
    private final List<ChildrenGroupFactory<R, O, M, E>> childrenGroups = new ArrayList<ChildrenGroupFactory<R, O, M, E>>();

    public AdaptedChildFactory(String configurationPathPrefix, M modelPrototype, AdaptedChildVisualFactory<M> viewFactory, AbstractAdaptedFactory<R, O, ?, ?, ?> parentAdaptedModel) {
        super(configurationPathPrefix, modelPrototype, () -> new AdaptedChildImpl(), parentAdaptedModel);
        this.viewFactory = viewFactory;
    }

    protected AdaptedChildFactory(String configurationPathPrefix, M modelPrototype, Supplier<A> newAdaptedModel, AdaptedChildVisualFactory<M> viewFactory, OfficeFloorContentPartFactory<R, O> contentPartFactory) {
        super(configurationPathPrefix, modelPrototype, newAdaptedModel, contentPartFactory);
        this.viewFactory = viewFactory;
    }

    @Override
    @SafeVarargs
    public final void label(Function<M, String> getLabel, E ... labelChangeEvents) {
        this.label(getLabel, null, (Enum[])labelChangeEvents);
    }

    @Override
    @SafeVarargs
    public final void label(Function<M, String> getLabel, AdaptedChildBuilder.LabelChange<M> setLabel, E ... labelChangeEvents) {
        this.getLabel = getLabel;
        this.setLabel = setLabel;
        this.labelEvents = labelChangeEvents;
    }

    @Override
    @SafeVarargs
    public final ChildrenGroupBuilder<R, O> children(String childGroupName, Function<M, List<? extends Model>> getChildren, E ... childrenEvents) {
        ChildrenGroupFactory factory = new ChildrenGroupFactory(this.getConfigurationPath(), childGroupName, getChildren, childrenEvents, (AbstractAdaptedFactory)this);
        this.childrenGroups.add(factory);
        return factory;
    }

    protected static class AdaptedChildImpl<R extends Model, O, M extends Model, E extends Enum<E>, A extends AdaptedChild<M>>
    extends AbstractAdaptedConnectableFactory.AbstractAdaptedConnectable<R, O, M, E, A, AdaptedChildFactory<R, O, M, E, A>>
    implements AdaptedChild<M> {
        private ReadOnlyStringWrapper label;
        private ReadOnlyStringWrapper labelConflict;
        private List<ChildrenGroup<M, ?>> childrenGroups;

        protected AdaptedChildImpl() {
        }

        @Override
        protected void init() {
            super.init();
            this.childrenGroups = new ArrayList(((AdaptedChildFactory)this.getFactory()).childrenGroups.size());
            for (ChildrenGroupFactory childrenGroupFactory : ((AdaptedChildFactory)this.getFactory()).childrenGroups) {
                this.childrenGroups.add(childrenGroupFactory.createChildrenGroup(this));
            }
            if (((AdaptedChildFactory)this.getFactory()).getLabel == null) {
                this.label = null;
                this.labelConflict = null;
            } else {
                this.labelConflict = new ReadOnlyStringWrapper("");
                String initialLabel = (String)((AdaptedChildFactory)this.getFactory()).getLabel.apply(this.getModel());
                this.label = new ReadOnlyStringWrapper(this.getModel(), "Label", initialLabel != null ? initialLabel : "");
                if (((AdaptedChildFactory)this.getFactory()).setLabel != null) {
                    this.label.addListener((lister, oldValue, newValue) -> {
                        String currentValue = (String)((AdaptedChildFactory)this.getFactory()).getLabel.apply(this.getModel());
                        currentValue = currentValue == null ? "" : currentValue;
                        String string = newValue = newValue == null ? "" : newValue;
                        if (currentValue.equals(newValue)) {
                            return;
                        }
                        Change change = ((AdaptedChildFactory)this.getFactory()).setLabel.changeLabel((Model)this.getModel(), (String)newValue);
                        Conflict[] conflicts = change.getConflicts();
                        if (conflicts.length > 0) {
                            StringBuilder message = new StringBuilder(conflicts[0].getConflictDescription());
                            int i = 1;
                            while (i < conflicts.length) {
                                message.append("\n");
                                message.append(conflicts[i].getConflictDescription());
                                ++i;
                            }
                            this.labelConflict.set(message.toString());
                            return;
                        }
                        this.labelConflict.set("");
                        this.label.set(newValue);
                        this.getChangeExecutor().execute(change);
                    });
                }
                this.registerEventListener(((AdaptedChildFactory)this.getFactory()).labelEvents, event -> {
                    String newLabel = (String)event.getNewValue();
                    this.label.set(newLabel);
                });
            }
        }

        public ReadOnlyStringProperty getLabel() {
            return this.label == null ? null : this.label.getReadOnlyProperty();
        }

        public StringProperty getEditLabel() {
            return this.label;
        }

        @Override
        public Property<String> getStylesheet() {
            return ((AdaptedChildFactory)this.getFactory()).stylesheetContent;
        }

        @Override
        public ReadOnlyProperty<URL> getStylesheetUrl() {
            return ((AdaptedChildFactory)this.getFactory()).stylesheetUrl;
        }

        @Override
        public List<ChildrenGroup<M, ?>> getChildrenGroups() {
            return this.childrenGroups;
        }

        @Override
        public Node createVisual(AdaptedChildVisualFactoryContext<M> context) {
            return ((AdaptedChildFactory)this.getFactory()).viewFactory.createVisual(this.getModel(), context);
        }

        @Override
        public SelectOnly getSelectOnly() {
            return ((AdaptedChildFactory)this.getFactory()).getContentPartFactory().getSelectOnly();
        }

        @Override
        protected void loadDescendantConnections(List<AdaptedConnection<?>> connections) {
            for (ChildrenGroup<M, ?> group : this.childrenGroups) {
                for (AdaptedChild child : group.getChildren()) {
                    connections.addAll(child.getConnections());
                }
            }
        }
    }
}

