/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.officefloor.eclipse.editor.AdaptedConnectable;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.AdaptedConnectionBuilder;
import net.officefloor.eclipse.editor.AdaptedConnectionManagementBuilder;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.AdaptedPotentialConnection;
import net.officefloor.eclipse.editor.ModelActionContext;
import net.officefloor.eclipse.editor.OverlayVisualFactory;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedConnectableFactory;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedChildFactory;
import net.officefloor.eclipse.editor.internal.models.ModelToConnection;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;

public class AdaptedConnectionFactory<R extends Model, O, S extends Model, C extends ConnectionModel, E extends Enum<E>>
extends AbstractAdaptedFactory<R, O, C, E, AdaptedConnection<C>>
implements AdaptedConnectionBuilder<R, O, S, C, E>,
AdaptedConnectionManagementBuilder<R, O, S, C, Model>,
AdaptedPotentialConnection {
    private final Class<S> sourceModelClass;
    private final Function<C, S> getSource;
    private Function<C, ? extends Model> getTarget;
    private Class<?> targetModelClass;
    private ModelToConnection<R, O, ?, ?, ?> targetConnector;
    private AdaptedConnectionManagementBuilder.ConnectionFactory<R, O, ? extends Model, ? extends ConnectionModel, ? extends Model> createConnection;
    private AdaptedConnectionManagementBuilder.ConnectionRemover<R, O, C> removeConnection;
    private final AdaptedErrorHandler errorHandler;

    public AdaptedConnectionFactory(String configurationPathPrefix, Class<C> connectionClass, Class<S> sourceModelClass, Function<C, S> getSource, AbstractAdaptedConnectableFactory<R, O, ?, ?, ?> adaptedChildModelFactory) {
        super(configurationPathPrefix, connectionClass, () -> new AdaptedConnectionImpl(), adaptedChildModelFactory);
        this.sourceModelClass = sourceModelClass;
        this.getSource = getSource;
        this.errorHandler = adaptedChildModelFactory.getContentPartFactory().getErrorHandler();
    }

    public void createConnection(Model source, Model target) {
        if (!this.sourceModelClass.equals(source.getClass()) || !this.targetModelClass.equals(target.getClass())) {
            throw new IllegalStateException("Models " + source.getClass().getName() + " and " + target.getClass().getName() + " does not match connection " + this.sourceModelClass.getName() + " source and " + this.targetModelClass.getName() + " target");
        }
        this.getContentPartFactory().addConnection(source, target, this.createConnection);
    }

    @Override
    public Class<?> getSourceModelClass() {
        return this.sourceModelClass;
    }

    @Override
    public Class<?> getTargetModelClass() {
        return this.targetModelClass;
    }

    @Override
    public boolean canCreateConnection() {
        return this.createConnection != null;
    }

    @Override
    public void init(Injector injector, Map<Class<?>, AbstractAdaptedFactory<R, O, ?, ?, ?>> models) {
        super.init(injector, models);
        AbstractAdaptedFactory<R, O, ?, ?, ?> factory = models.get(this.targetModelClass);
        if (factory == null) {
            throw new IllegalStateException("Target model " + this.targetModelClass.getName() + " of connection " + this.getModelClass().getName() + " is not configured");
        }
        if (!(factory instanceof AdaptedChildFactory)) {
            throw new IllegalStateException("Target model " + this.targetModelClass.getName() + " of connection " + this.getModelClass().getName() + " must be an " + AdaptedChildFactory.class.getName());
        }
        AdaptedChildFactory adaptedChildFactory = (AdaptedChildFactory)factory;
        adaptedChildFactory.loadModelToConnection(this.getModelClass(), this.targetConnector);
    }

    @Override
    @SafeVarargs
    public final <T extends Model, TE extends Enum<TE>> AdaptedConnectionManagementBuilder<R, O, S, C, T> toOne(Class<T> targetModel, Function<T, C> getConnection, Function<C, T> getTarget, TE ... targetChangeEvents) {
        return this.toMany(targetModel, model -> {
            ConnectionModel connection = (ConnectionModel)getConnection.apply(model);
            if (connection == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(connection);
        }, getTarget, (Enum[])targetChangeEvents);
    }

    @Override
    @SafeVarargs
    public final <T extends Model, TE extends Enum<TE>> AdaptedConnectionManagementBuilder<R, O, S, C, T> toMany(Class<T> targetModel, Function<T, List<C>> getConnections, Function<C, T> getTarget, TE ... targetChangeEvents) {
        this.targetModelClass = targetModel;
        this.getTarget = getTarget;
        this.targetConnector = new ModelToConnection(getConnections, targetChangeEvents, this);
        return this;
    }

    @Override
    public AdaptedConnectionManagementBuilder<R, O, S, C, Model> create(AdaptedConnectionManagementBuilder.ConnectionFactory<R, O, S, C, Model> createConnection) {
        this.createConnection = createConnection;
        return this;
    }

    @Override
    public AdaptedConnectionManagementBuilder<R, O, S, C, Model> delete(AdaptedConnectionManagementBuilder.ConnectionRemover<R, O, C> removeConnection) {
        this.removeConnection = removeConnection;
        return this;
    }

    public static class AdaptedConnectionImpl<R extends Model, O, S extends Model, C extends ConnectionModel, E extends Enum<E>>
    extends AbstractAdaptedFactory.AbstractAdaptedModel<R, O, C, E, AdaptedConnection<C>, AdaptedConnectionFactory<R, O, S, C, E>>
    implements AdaptedConnection<C>,
    ModelActionContext<R, O, C> {
        @Override
        protected void init() {
        }

        @Override
        public AdaptedConnectable<?> getSource() {
            Model source = (Model)((AdaptedConnectionFactory)this.getFactory()).getSource.apply((ConnectionModel)this.getModel());
            return (AdaptedConnectable)((AdaptedConnectionFactory)this.getFactory()).getAdaptedModel(source, null);
        }

        @Override
        public AdaptedConnectable<?> getTarget() {
            Model target = (Model)((AdaptedConnectionFactory)this.getFactory()).getTarget.apply((ConnectionModel)this.getModel());
            return (AdaptedConnectable)((AdaptedConnectionFactory)this.getFactory()).getAdaptedModel(target, null);
        }

        @Override
        public boolean canRemove() {
            return ((AdaptedConnectionFactory)this.getFactory()).removeConnection != null;
        }

        @Override
        public void remove() {
            if (this.canRemove()) {
                ((AdaptedConnectionFactory)this.getFactory()).errorHandler.isError(() -> ((AdaptedConnectionFactory)this.getFactory()).removeConnection.removeConnection(this));
            }
        }

        @Override
        public AdaptedModel<C> getAdaptedModel() {
            return this;
        }

        @Override
        public void overlay(OverlayVisualFactory overlayVisualFactory) {
            Object model = this.getTarget().getModel();
            ((AdaptedConnectionFactory)this.getFactory()).getContentPartFactory().overlay(model.getX(), model.getY(), overlayVisualFactory);
        }
    }
}

