/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.util.List;
import net.officefloor.eclipse.editor.AdaptedConnectable;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedConnectorRole;
import net.officefloor.eclipse.editor.internal.models.ModelToConnection;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;

public class AdaptedConnectorImpl<R extends Model, O, M extends Model>
implements AdaptedConnector<M> {
    private final AdaptedConnectable<M> parentAdaptedConnectable;
    private final Class<? extends ConnectionModel> connectionClass;
    private final AdaptedConnectorRole role;
    private final ModelToConnection<R, O, M, ?, ? extends ConnectionModel> modelToConnection;
    private List<AdaptedConnector<M>> associatedAdaptedConnectors;
    private AdaptedConnectorRole associatedRole;

    public AdaptedConnectorImpl(AdaptedConnectable<M> parentAdaptedConnectable, Class<? extends ConnectionModel> connectionClass, AdaptedConnectorRole role, ModelToConnection<R, O, M, ?, ? extends ConnectionModel> modelToConnection) {
        this.parentAdaptedConnectable = parentAdaptedConnectable;
        this.connectionClass = connectionClass;
        this.role = role;
        this.modelToConnection = modelToConnection;
    }

    @Override
    public AdaptedConnectable<M> getParentAdaptedConnectable() {
        return this.parentAdaptedConnectable;
    }

    @Override
    public Class<? extends ConnectionModel> getConnectionModelClass() {
        return this.connectionClass;
    }

    @Override
    public void setAssociation(List<AdaptedConnector<M>> associatedAdaptedConnectors, AdaptedConnectorRole associatedRole) {
        this.associatedAdaptedConnectors = associatedAdaptedConnectors;
        this.associatedRole = associatedRole;
        if (this.role != null && !this.role.equals((Object)associatedRole)) {
            throw new IllegalStateException("Associated role does not match role of connector for " + this.connectionClass.getName() + " of model" + this.parentAdaptedConnectable.getModel().getClass().getName());
        }
    }

    @Override
    public boolean isAssociationCreateConnection() {
        for (AdaptedConnector<M> connector : this.associatedAdaptedConnectors) {
            AdaptedConnectorImpl impl = (AdaptedConnectorImpl)connector;
            if (!impl.modelToConnection.getAdaptedConnectionFactory().canCreateConnection()) continue;
            return true;
        }
        return false;
    }

    @Override
    public AdaptedConnectorRole getAssociationRole() {
        return this.associatedRole;
    }
}

