/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import com.google.inject.Injector;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.officefloor.eclipse.editor.AdaptedActionVisualFactory;
import net.officefloor.eclipse.editor.AdaptedArea;
import net.officefloor.eclipse.editor.AdaptedAreaBuilder;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactory;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.AdaptedParent;
import net.officefloor.eclipse.editor.AdaptedParentBuilder;
import net.officefloor.eclipse.editor.ChangeExecutor;
import net.officefloor.eclipse.editor.ModelAction;
import net.officefloor.eclipse.editor.ModelActionContext;
import net.officefloor.eclipse.editor.OverlayVisualFactory;
import net.officefloor.eclipse.editor.ParentToAreaConnectionModel;
import net.officefloor.eclipse.editor.internal.models.AdaptedActions;
import net.officefloor.eclipse.editor.internal.models.AdaptedActionsFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedAreaFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedChildFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedPrototype;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorContentPartFactory;
import net.officefloor.model.Model;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class AdaptedParentFactory<R extends Model, O, M extends Model, E extends Enum<E>>
extends AdaptedChildFactory<R, O, M, E, AdaptedParent<M>>
implements AdaptedParentBuilder<R, O, M, E> {
    private final AdaptedErrorHandler errorHandler;
    private ModelAction<R, O, M> parentModelProvider = null;
    private final List<Function<M, List<? extends Model>>> areas = new LinkedList<Function<M, List<? extends Model>>>();
    private final Set<String> areaChangeEvents = new HashSet<String>();
    private final AdaptedActionsFactory<R, O, M> actionsFactory;

    public AdaptedParentFactory(String configurationPathPrefix, M modelPrototype, AdaptedChildVisualFactory<M> viewFactory, OfficeFloorContentPartFactory<R, O> contentFactory) {
        super(configurationPathPrefix, modelPrototype, () -> new AdaptedParentImpl(), viewFactory, contentFactory);
        this.errorHandler = contentFactory.getErrorHandler();
        this.actionsFactory = new AdaptedActionsFactory(contentFactory);
    }

    public boolean isCreate() {
        return this.parentModelProvider != null;
    }

    public AdaptedModel<M> createPrototype(OfficeFloorContentPartFactory<R, O> factory) {
        AdaptedParentImpl prototype = (AdaptedParentImpl)factory.createAdaptedModel(this.modelPrototype, null);
        prototype.isPalettePrototype = true;
        return prototype;
    }

    @Override
    public void create(ModelAction<R, O, M> parentModelProvider) {
        this.parentModelProvider = parentModelProvider;
    }

    @Override
    public void action(ModelAction<R, O, M> action, AdaptedActionVisualFactory visualFactory) {
        this.actionsFactory.addAction(action, visualFactory);
    }

    @Override
    public <AM extends Model, AE extends Enum<AE>, RE extends Enum<RE>> AdaptedAreaBuilder<R, O, AM, AE> area(AM areaPrototype, Function<M, List<AM>> getAreas, Function<AM, Dimension> getDimension, BiConsumer<AM, Dimension> setDimension, E ... changeAreaEvents) {
        this.areas.add(getAreas);
        E[] EArray = changeAreaEvents;
        int n = changeAreaEvents.length;
        int n2 = 0;
        while (n2 < n) {
            E changeAreaEvent = EArray[n2];
            this.areaChangeEvents.add(((Enum)changeAreaEvent).name());
            ++n2;
        }
        AdaptedAreaFactory factory = new AdaptedAreaFactory(this.getConfigurationPath(), areaPrototype, this, getDimension, setDimension);
        factory.connectOne(ParentToAreaConnectionModel.class, area -> {
            AdaptedArea adaptedArea = (AdaptedArea)this.getContentPartFactory().createAdaptedModel(area, null);
            return adaptedArea.getParentConnection();
        }, conn -> conn.getAreaModel(), new Enum[0]).toMany(this.getModelClass(), parent -> {
            AdaptedParent adaptedParent = (AdaptedParent)this.getContentPartFactory().createAdaptedModel(parent, null);
            LinkedList<ParentToAreaConnectionModel> connections = new LinkedList<ParentToAreaConnectionModel>();
            for (AdaptedArea<?> adaptedArea : adaptedParent.getAdaptedAreas()) {
                connections.add(adaptedArea.getParentConnection());
            }
            return connections;
        }, conn -> conn.getParentModel(), new Enum[0]);
        return factory;
    }

    public static class AdaptedParentImpl<R extends Model, O, M extends Model, E extends Enum<E>>
    extends AdaptedChildFactory.AdaptedChildImpl<R, O, M, E, AdaptedParent<M>>
    implements AdaptedParent<M>,
    AdaptedPrototype<M> {
        private boolean isPalettePrototype = false;
        private AdaptedActions<R, O, M> actions;

        @Override
        protected void init() {
            super.init();
            this.actions = ((AdaptedParentFactory)this.getParentFactory()).actionsFactory.createAdaptedActions(this);
        }

        private AdaptedParentFactory<R, O, M, E> getParentFactory() {
            return (AdaptedParentFactory)this.getFactory();
        }

        @Override
        public boolean isPalettePrototype() {
            return this.isPalettePrototype;
        }

        @Override
        public List<AdaptedArea<?>> getAdaptedAreas() {
            LinkedList areas = new LinkedList();
            for (Function getAreas : ((AdaptedParentFactory)this.getParentFactory()).areas) {
                for (Model areaModel : (List)getAreas.apply(this.getModel())) {
                    AdaptedArea adaptedArea = (AdaptedArea)((AdaptedChildFactory)this.getFactory()).getContentPartFactory().createAdaptedModel(areaModel, this.getAdaptedModel());
                    if (areas.contains(adaptedArea)) continue;
                    areas.add(adaptedArea);
                }
            }
            return areas;
        }

        @Override
        public boolean isAreaChangeEvent(String eventName) {
            return ((AdaptedParentFactory)this.getParentFactory()).areaChangeEvents.contains(eventName);
        }

        @Override
        public <T> T getAdapter(Class<T> classKey) {
            if (AdaptedPrototype.class.equals(classKey)) {
                if (((AdaptedParentFactory)this.getParentFactory()).parentModelProvider != null) {
                    return (T)this;
                }
            } else if (AdaptedActions.class.equals(classKey)) {
                return (T)this.actions;
            }
            return null;
        }

        @Override
        public void changeLocation(int x, int y) {
            this.getChangeExecutor().execute(new ChangeLocationOperation<Model>(this.getModel(), x, y));
        }

        @Override
        public void newAdaptedParent(final Point location) {
            ((AdaptedParentFactory)this.getParentFactory()).errorHandler.isError(() -> ((AdaptedParentFactory)this.getParentFactory()).parentModelProvider.execute(new ModelActionContext<R, O, M>(){

                @Override
                public R getRootModel() {
                    return this.getRootModel();
                }

                @Override
                public O getOperations() {
                    return this.getOperations();
                }

                @Override
                public M getModel() {
                    return this.getModel();
                }

                @Override
                public AdaptedModel<M> getAdaptedModel() {
                    return this.getAdaptedModel();
                }

                @Override
                public Injector getInjector() {
                    return this.getInjector();
                }

                @Override
                public void overlay(OverlayVisualFactory overlayVisualFactory) {
                    this.getParentFactory().getContentPartFactory().overlay(location.x, location.y, overlayVisualFactory);
                }

                @Override
                public ChangeExecutor getChangeExecutor() {
                    return this.getChangeExecutor();
                }

                @Override
                public M position(M model) {
                    model.setX((int)location.x);
                    model.setY((int)location.y);
                    return model;
                }
            }));
        }
    }

    private static class ChangeLocationOperation<M extends Model>
    extends AbstractOperation
    implements ITransactionalOperation {
        private final M model;
        private final int originalX;
        private final int originalY;
        private final int newX;
        private final int newY;

        public ChangeLocationOperation(M model, int newX, int newY) {
            super("change location");
            this.model = model;
            this.newX = newX;
            this.newY = newY;
            this.originalX = this.model.getX();
            this.originalY = this.model.getY();
        }

        public boolean isContentRelevant() {
            return true;
        }

        public boolean isNoOp() {
            return false;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.model.setX(this.newX);
            this.model.setY(this.newY);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.model.setX(this.originalX);
            this.model.setY(this.originalY);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }
    }
}

