/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.util.LinkedList;
import java.util.List;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.ChangeExecutor;
import net.officefloor.eclipse.editor.ChangeListener;
import net.officefloor.eclipse.editor.internal.parts.OfficeFloorContentPartFactory;
import net.officefloor.model.change.Change;
import net.officefloor.model.change.Conflict;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class ChangeExecutorImpl
implements ChangeExecutor {
    private final OfficeFloorContentPartFactory<?, ?> contentPartFactory;
    private final IDomain domain;
    private final List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();

    public ChangeExecutorImpl(OfficeFloorContentPartFactory<?, ?> contentPartFactory, IDomain domain) {
        this.contentPartFactory = contentPartFactory;
        this.domain = domain;
    }

    @Override
    public void execute(Change<?> change) {
        this.contentPartFactory.getErrorHandler().isError(() -> {
            if (!change.canApply()) {
                StringBuilder message = new StringBuilder();
                boolean isFirst = true;
                Conflict[] conflictArray = change.getConflicts();
                int n = conflictArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Conflict conflict = conflictArray[n2];
                    Throwable cause = conflict.getConflictCause();
                    if (cause != null) {
                        throw cause;
                    }
                    if (!isFirst) {
                        message.append(System.lineSeparator());
                    }
                    isFirst = false;
                    String description = conflict.getConflictDescription();
                    if (description == null || description.trim().length() == 0) {
                        description = "Conflict in making change";
                    }
                    message.append(description);
                    ++n2;
                }
                throw new AdaptedErrorHandler.MessageOnlyException(message.toString());
            }
            this.domain.execute((ITransactionalOperation)new ChangeTransactionalOperation(change), null);
        });
    }

    @Override
    public void execute(ITransactionalOperation operation) {
        this.contentPartFactory.getErrorHandler().isError(() -> {
            for (ChangeListener listener : this.changeListeners) {
                listener.beforeTransactionOperation(operation);
            }
            this.domain.execute(operation, null);
            for (ChangeListener listener : this.changeListeners) {
                listener.afterTransactionOperation(operation);
            }
        });
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private class ChangeTransactionalOperation
    extends AbstractOperation
    implements ITransactionalOperation {
        private final Change<?> change;

        private ChangeTransactionalOperation(Change<?> change) {
            super(change.getChangeDescription());
            this.change = change;
        }

        private IStatus runUncertain(AdaptedErrorHandler.UncertainOperation operation) {
            ChangeExecutorImpl.this.contentPartFactory.getErrorHandler().isError(operation);
            return Status.OK_STATUS;
        }

        private IStatus apply() {
            return this.runUncertain(() -> {
                for (ChangeListener listener : ChangeExecutorImpl.this.changeListeners) {
                    listener.preApply(this.change);
                }
                this.change.apply();
                for (ChangeListener listener : ChangeExecutorImpl.this.changeListeners) {
                    listener.postApply(this.change);
                }
            });
        }

        private IStatus revert() {
            return this.runUncertain(() -> {
                for (ChangeListener listener : ChangeExecutorImpl.this.changeListeners) {
                    listener.preRevert(this.change);
                }
                this.change.revert();
                for (ChangeListener listener : ChangeExecutorImpl.this.changeListeners) {
                    listener.postRevert(this.change);
                }
            });
        }

        public boolean isContentRelevant() {
            return true;
        }

        public boolean isNoOp() {
            return false;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.apply();
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.revert();
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.apply();
        }
    }
}

