/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ObservableList;
import net.officefloor.eclipse.editor.AdaptedChild;
import net.officefloor.eclipse.editor.AdaptedChildBuilder;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactory;
import net.officefloor.eclipse.editor.ChildrenGroup;
import net.officefloor.eclipse.editor.ChildrenGroupBuilder;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedChildFactory;
import net.officefloor.model.Model;
import org.eclipse.gef.common.collections.CollectionUtils;

public class ChildrenGroupFactory<R extends Model, O, M extends Model, E extends Enum<E>>
implements ChildrenGroupBuilder<R, O> {
    private final String configurationPath;
    private final String childGroupName;
    private final Function<M, List<? extends Model>> getChildren;
    private final E[] childrenEvents;
    private final AbstractAdaptedFactory<R, O, ?, ?, ?> parentAdaptedModel;

    public ChildrenGroupFactory(String configurationPathPrefix, String childGroupName, Function<M, List<? extends Model>> getChildren, E[] childrenEvents, AbstractAdaptedFactory<R, O, ?, ?, ?> parentAdaptedModel) {
        this.configurationPath = String.valueOf(configurationPathPrefix) + "." + childGroupName;
        this.childGroupName = childGroupName;
        this.getChildren = getChildren;
        this.childrenEvents = childrenEvents;
        this.parentAdaptedModel = parentAdaptedModel;
    }

    public ChildrenGroup<M, E> createChildrenGroup(AdaptedChild<M> parent) {
        return new ChildrenGroupImpl(parent, this);
    }

    @Override
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    @Override
    public <CM extends Model, CE extends Enum<CE>> AdaptedChildBuilder<R, O, CM, CE> addChild(CM modelPrototype, AdaptedChildVisualFactory<CM> viewFactory) {
        return new AdaptedChildFactory(this.configurationPath, modelPrototype, viewFactory, this.parentAdaptedModel);
    }

    public static class ChildrenGroupImpl<R extends Model, O, M extends Model, E extends Enum<E>>
    implements ChildrenGroup<M, E> {
        private final AdaptedChild<M> parent;
        private final ChildrenGroupFactory<? extends Model, ?, M, E> factory;
        private final ObservableList<AdaptedChild<?>> children;

        private ChildrenGroupImpl(AdaptedChild<M> parent, ChildrenGroupFactory<? extends Model, ?, M, E> factory) {
            this.parent = parent;
            this.factory = factory;
            this.children = CollectionUtils.observableArrayList();
            Runnable loadChildren = () -> {
                List children = (List)((ChildrenGroupFactory)this.factory).getChildren.apply(this.parent.getModel());
                ArrayList<AdaptedChild> adaptedChildren = new ArrayList<AdaptedChild>(children.size());
                for (Model child : children) {
                    AdaptedChild adaptedChild = (AdaptedChild)((ChildrenGroupFactory)this.factory).parentAdaptedModel.getAdaptedModel(child, this.parent);
                    adaptedChildren.add(adaptedChild);
                }
                this.children.setAll(adaptedChildren);
            };
            loadChildren.run();
            AdaptedChildFactory.registerEventListener(this.parent.getModel(), (Enum[])((ChildrenGroupFactory)this.factory).childrenEvents, event -> loadChildren.run());
        }

        @Override
        public AdaptedChild<M> getParent() {
            return this.parent;
        }

        @Override
        public String getChildrenGroupName() {
            return ((ChildrenGroupFactory)this.factory).childGroupName;
        }

        @Override
        public ObservableList<AdaptedChild<?>> getChildren() {
            return this.children;
        }

        @Override
        public E[] getEvents() {
            return ((ChildrenGroupFactory)this.factory).childrenEvents;
        }
    }
}

