/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.models;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.officefloor.eclipse.editor.internal.models.ModelToConnection;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;

public class ModelToSelfConnection<R extends Model, O, M extends Model, E extends Enum<E>, C extends ConnectionModel>
extends ModelToConnection<R, O, M, E, C> {
    private final ModelToConnection<R, O, M, E, C> sourceToConnection;
    private final ModelToConnection<R, O, M, E, C> targetToConnection;

    private static <R extends Model, O, M extends Model, E extends Enum<E>, C extends ConnectionModel> E[] combineEvents(ModelToConnection<R, O, M, E, C> sourceToConnection, ModelToConnection<R, O, M, E, C> targetToConnection) {
        E[] sourceEvents = sourceToConnection.connectionChangeEvents;
        E[] targetEvents = targetToConnection.connectionChangeEvents;
        Enum[] allEvents = (Enum[])Array.newInstance(sourceEvents.getClass().getComponentType(), sourceEvents.length + targetEvents.length);
        int i = 0;
        while (i < sourceEvents.length) {
            allEvents[i] = sourceEvents[i];
            ++i;
        }
        i = 0;
        while (i < targetEvents.length) {
            allEvents[sourceEvents.length + i] = targetEvents[i];
            ++i;
        }
        return allEvents;
    }

    public ModelToSelfConnection(ModelToConnection<R, O, M, E, C> sourceToConnection, ModelToConnection<R, O, M, E, C> targetToConnection) {
        super(m -> {
            List sourceConnections = modelToConnection.getConnections.apply(m);
            List targetConnections = modelToConnection2.getConnections.apply(m);
            ArrayList allConnections = new ArrayList(sourceConnections.size() + targetConnections.size());
            allConnections.addAll(sourceConnections);
            allConnections.addAll(targetConnections);
            return allConnections;
        }, ModelToSelfConnection.combineEvents(sourceToConnection, targetToConnection), sourceToConnection.adaptedConnectionFactory);
        this.sourceToConnection = sourceToConnection;
        this.targetToConnection = targetToConnection;
    }

    public ModelToConnection<R, O, M, E, C> getSourceToConnection() {
        return this.sourceToConnection;
    }

    public ModelToConnection<R, O, M, E, C> getTargetToConnection() {
        return this.targetToConnection;
    }
}

