/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import net.officefloor.eclipse.editor.AdaptedConnectable;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.AdaptedModelStyler;
import net.officefloor.eclipse.editor.SelectOnly;
import net.officefloor.eclipse.editor.internal.parts.AbstractAdaptedPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedModelVisualFactoryContextImpl;
import net.officefloor.model.Model;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public abstract class AbstractAdaptedConnectablePart<M extends Model, A extends AdaptedConnectable<M>>
extends AbstractAdaptedPart<M, A, Node>
implements AdaptedModelStyler {
    protected boolean isPalettePrototype = false;
    private Map<AdaptedConnector<M>, AdaptedConnectorVisual> adaptedConnectorVisuals;

    public static void loadStyling(Node visualNode, Class<? extends Model> modelClass, ReadOnlyProperty<URL> stylesheetUrl) {
        if (!(visualNode instanceof Parent)) {
            return;
        }
        Parent childVisual = (Parent)visualNode;
        childVisual.getStyleClass().add((Object)"child");
        childVisual.getStyleClass().add((Object)modelClass.getSimpleName());
        if (stylesheetUrl != null) {
            URL initialUrl = (URL)stylesheetUrl.getValue();
            if (initialUrl != null) {
                childVisual.getStylesheets().add((Object)initialUrl.toExternalForm());
            }
            stylesheetUrl.addListener((event, oldValue, newValue) -> {
                if (oldValue != null) {
                    childVisual.getStylesheets().remove((Object)oldValue.toExternalForm());
                }
                if (newValue != null) {
                    childVisual.getStylesheets().add((Object)newValue.toExternalForm());
                }
            });
        }
    }

    public Region getAdaptedConnectorNode(AdaptedConnector<?> connector) {
        return this.adaptedConnectorVisuals.get(connector).node;
    }

    public AdaptedErrorHandler getErrorHandler() {
        return ((AdaptedConnectable)this.getContent()).getErrorHandler();
    }

    @Override
    public Model getModel() {
        return ((AdaptedConnectable)this.getContent()).getModel();
    }

    @Override
    public Property<String> style() {
        return ((AdaptedConnectable)this.getContent()).getStylesheet();
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
    }

    protected List<Object> doGetContentChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(((AdaptedConnectable)this.getContent()).getAdaptedConnectors());
        return children;
    }

    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
    }

    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
    }

    protected abstract Node createVisualNode();

    public Node doCreateVisual() {
        Node visualNode = this.createVisualNode();
        for (AdaptedConnector connector : ((AdaptedConnectable)this.getContent()).getAdaptedConnectors()) {
            AdaptedConnectorVisual visual = this.adaptedConnectorVisuals.get(connector);
            if (visual.node != null) continue;
            throw new IllegalStateException("Connector to " + connector.getConnectionModelClass().getName() + " not configured in view of model " + ((AdaptedConnectable)this.getContent()).getModel().getClass().getName());
        }
        AbstractAdaptedConnectablePart.loadStyling(visualNode, ((AdaptedConnectable)this.getContent()).getModel().getClass(), ((AdaptedConnectable)this.getContent()).getStylesheetUrl());
        SelectOnly selectOnly = ((AdaptedConnectable)this.getContent()).getSelectOnly();
        if (selectOnly != null) {
            visualNode.setOnMouseClicked(event -> {
                ((AdaptedConnectable)this.getContent()).getErrorHandler().isError(() -> selectOnly.model(this));
                event.consume();
            });
        }
        return visualNode;
    }

    protected void doRefreshVisual(Node visual) {
    }

    protected AdaptedModelVisualFactoryContextImpl.ConnectorLoader<M> getConnectorLoader() {
        this.adaptedConnectorVisuals = new HashMap<AdaptedConnector<M>, AdaptedConnectorVisual>();
        for (AdaptedConnector adaptedConnector : ((AdaptedConnectable)this.getContent()).getAdaptedConnectors()) {
            this.adaptedConnectorVisuals.put(adaptedConnector, new AdaptedConnectorVisual());
        }
        return (connectionClasses, role, assocations, node) -> {
            Class[] classArray = connectionClasses;
            int n = connectionClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class connectionClass = classArray[n2];
                AdaptedConnector connector = ((AdaptedConnectable)this.getContent()).getAdaptedConnector(connectionClass, role);
                if (connector == null) {
                    throw new IllegalStateException("Connection " + connectionClass.getName() + " not configured to connect to model " + ((AdaptedConnectable)this.getContent()).getModel().getClass().getName());
                }
                AdaptedConnectorVisual visual = this.adaptedConnectorVisuals.get(connector);
                if (visual.node != null) {
                    throw new IllegalStateException("Connection " + connectionClass.getName() + " configured more than once for model " + ((AdaptedConnectable)this.getContent()).getModel().getClass().getName());
                }
                visual.node = node;
                assocations.add(connector);
                connector.setAssociation(assocations, role);
                ++n2;
            }
        };
    }

    private static class AdaptedConnectorVisual {
        private Region node = null;

        private AdaptedConnectorVisual() {
        }
    }
}

