/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import java.util.Set;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.editor.AdaptedActionVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultImages;
import net.officefloor.eclipse.editor.internal.models.AdaptedAction;
import net.officefloor.model.Model;
import org.eclipse.gef.common.collections.SetMultimapChangeListener;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.parts.AbstractHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class AdaptedActionHandlePart<R extends Model, O, M extends Model>
extends AbstractHandlePart<Node>
implements AdaptedActionVisualFactoryContext {
    private boolean registered = false;
    private AdaptedAction<R, O, M> adaptedAction;
    private final SetMultimapChangeListener<IVisualPart<? extends Node>, String> parentAnchoragesChangeListener = change -> {
        IViewer oldViewer = this.getViewer(change.getPreviousContents().keySet());
        IViewer newViewer = this.getViewer(change.getSetMultimap().keySet());
        if (this.registered && oldViewer != null && oldViewer != newViewer) {
            oldViewer.unsetAdapter((Object)this);
        }
        if (!this.registered && newViewer != null && oldViewer != newViewer) {
            newViewer.setAdapter((Object)this, String.valueOf(System.identityHashCode(this)));
        }
    };

    public void setAdaptedAction(AdaptedAction<R, O, M> adaptedAction) {
        this.adaptedAction = adaptedAction;
        this.setAdapter((Object)new AdaptedActionIOnClickHandler());
    }

    private IViewer getViewer(Set<? extends IVisualPart<? extends Node>> anchorages) {
        for (IVisualPart<? extends Node> iVisualPart : anchorages) {
            if (iVisualPart.getRoot() == null || iVisualPart.getRoot().getViewer() == null) continue;
            return iVisualPart.getRoot().getViewer();
        }
        return null;
    }

    protected void register(IViewer viewer) {
        if (this.registered) {
            return;
        }
        super.register(viewer);
        this.registered = true;
    }

    public void setParent(IVisualPart<? extends Node> newParent) {
        if (this.getParent() != null) {
            this.getParent().getAnchoragesUnmodifiable().removeListener(this.parentAnchoragesChangeListener);
        }
        if (newParent != null) {
            newParent.getAnchoragesUnmodifiable().addListener(this.parentAnchoragesChangeListener);
        }
        super.setParent(newParent);
    }

    protected Node doCreateVisual() {
        return this.adaptedAction.createVisual(this);
    }

    public void doRefreshVisual(Node visual) {
    }

    protected void unregister(IViewer viewer) {
        if (!this.registered) {
            return;
        }
        super.unregister(viewer);
        this.registered = false;
    }

    @Override
    public <N extends Node> N addNode(Pane parent, N node) {
        parent.getChildren().add(node);
        return node;
    }

    @Override
    public Node createImageWithHover(Class<?> resourceClass, String imageFilePath, String hoverImageFilePath) {
        Node node = DefaultImages.createImageWithHover(resourceClass, imageFilePath, hoverImageFilePath);
        node.getStyleClass().add((Object)"action");
        return node;
    }

    private class AdaptedActionIOnClickHandler
    extends AbstractHandler
    implements IOnClickHandler {
        private AdaptedActionIOnClickHandler() {
        }

        public void click(MouseEvent event) {
            AdaptedActionHandlePart.this.adaptedAction.execute();
            event.consume();
        }
    }
}

