/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import java.util.function.Supplier;
import javafx.beans.property.ReadOnlyProperty;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.editor.internal.parts.AdaptedModelVisualFactoryContextImpl;
import net.officefloor.model.Model;

public class AdaptedChildVisualFactoryContextImpl<M extends Model>
extends AdaptedModelVisualFactoryContextImpl<M>
implements AdaptedChildVisualFactoryContext<M> {
    private final Supplier<ReadOnlyProperty<String>> label;
    private final ChildGroupRegistrator childGroupRegistrator;

    public AdaptedChildVisualFactoryContextImpl(Class<M> modelClass, boolean isPalettePrototype, Supplier<ReadOnlyProperty<String>> label, ChildGroupRegistrator childGroupRegistrator, AdaptedModelVisualFactoryContextImpl.ConnectorLoader<M> connectorLoader, AdaptedModelVisualFactoryContextImpl.Actioner<M> actioner) {
        super(modelClass, isPalettePrototype, connectorLoader, actioner);
        this.label = label;
        this.childGroupRegistrator = childGroupRegistrator;
    }

    @Override
    public Label label(Pane parent) {
        ReadOnlyProperty<String> labelProperty = this.label.get();
        if (labelProperty == null) {
            throw new IllegalStateException("No label configured for visual for model " + this.modelClass.getName());
        }
        Label label = this.addNode(parent, new Label());
        label.textProperty().bind(labelProperty);
        return label;
    }

    @Override
    public <P extends Pane> P childGroup(String childGroupName, P parent) {
        if (childGroupName == null) {
            throw new NullPointerException("No child group name provided for view of " + this.modelClass.getName());
        }
        if (this.childGroupRegistrator.registerChildGroup(childGroupName, parent)) {
            return parent;
        }
        throw new IllegalStateException("No children group '" + childGroupName + "' registered for view of model " + this.modelClass.getName());
    }

    @Override
    public boolean isPalettePrototype() {
        return this.isPalettePrototype;
    }

    public static interface ChildGroupRegistrator {
        public boolean registerChildGroup(String var1, Pane var2);
    }
}

