/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import net.officefloor.eclipse.editor.AdaptedConnectable;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedConnectorRole;
import net.officefloor.eclipse.editor.internal.models.ProxyAdaptedConnection;
import net.officefloor.eclipse.editor.internal.parts.AbstractAdaptedPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedAreaPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectorPart;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.nodes.PolyBezierInterpolator;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.providers.IAnchorProvider;

public class AdaptedConnectionPart<R extends Model, O, C extends ConnectionModel>
extends AbstractAdaptedPart<C, AdaptedConnection<C>, Connection>
implements IBendableContentPart<Connection> {
    private IVisualPart<? extends Node> parent = null;
    private AdaptedConnector<?> sourceConnector;
    private AdaptedConnector<?> targetConnector;

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        AdaptedConnectable<?> targetChild;
        HashMultimap anchorages = HashMultimap.create();
        if (this.getContent() instanceof ProxyAdaptedConnection) {
            ProxyAdaptedConnection proxy = (ProxyAdaptedConnection)this.getContent();
            anchorages.put(proxy.getSourceAdaptedConnector(), (Object)"source");
            return anchorages;
        }
        AdaptedConnectable<?> sourceChild = ((AdaptedConnection)this.getContent()).getSource();
        if (sourceChild != null) {
            this.sourceConnector = sourceChild.getAdaptedConnector(((ConnectionModel)((AdaptedConnection)this.getContent()).getModel()).getClass(), AdaptedConnectorRole.SOURCE);
            anchorages.put(this.sourceConnector, (Object)"source");
        }
        if ((targetChild = ((AdaptedConnection)this.getContent()).getTarget()) != null) {
            this.targetConnector = targetChild.getAdaptedConnector(((ConnectionModel)((AdaptedConnection)this.getContent()).getModel()).getClass(), AdaptedConnectorRole.TARGET);
            anchorages.put(this.targetConnector, (Object)"target");
        }
        return anchorages;
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        if (!(anchorage instanceof AdaptedConnectorPart) && !(anchorage instanceof AdaptedAreaPart)) {
            throw new IllegalStateException("Attempting to attach non " + AdaptedConnectorPart.class.getSimpleName() + "/" + AdaptedAreaPart.class.getSimpleName() + " anchor to " + ((Object)((Object)this)).getClass().getSimpleName() + " for model " + ((ConnectionModel)((AdaptedConnection)this.getContent()).getModel()).getClass().getName());
        }
        IAnchorProvider anchorProvider = (IAnchorProvider)anchorage.getAdapter(IAnchorProvider.class);
        if (anchorProvider == null) {
            if (anchorage.getParent() == null) {
                throw new IllegalStateException("No parent for " + anchorage.getClass().getName());
            }
            throw new IllegalStateException("No " + IAnchorProvider.class.getSimpleName() + " provided by " + anchorage.getClass().getName());
        }
        IAnchor anchor = anchorProvider.get((IVisualPart)this, role);
        if (role.equals("source")) {
            ((Connection)this.getVisual()).setStartAnchor(anchor);
        } else if (role.equals("target")) {
            ((Connection)this.getVisual()).setEndAnchor(anchor);
        } else {
            throw new IllegalStateException("Cannot attach to anchor with role '" + role + "' for model " + ((AdaptedConnection)this.getContent()).getClass().getName());
        }
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    protected Connection doCreateVisual() {
        Connection connection = new Connection();
        connection.setInterpolator((IConnectionInterpolator)new PolyBezierInterpolator());
        connection.setRouter((IConnectionRouter)new OrthogonalRouter());
        connection.getStyleClass().add((Object)"connection");
        if (((AdaptedConnection)this.getContent()).getModel() != null) {
            connection.getStyleClass().add((Object)((ConnectionModel)((AdaptedConnection)this.getContent()).getModel()).getClass().getSimpleName());
        }
        connection.getStyleClass().add((Object)(((AdaptedConnection)this.getContent()).canRemove() ? "connection-delete" : "connection-not-delete"));
        return connection;
    }

    protected void doRefreshVisual(Connection visual) {
    }

    public List<IBendableContentPart.BendPoint> getContentBendPoints() {
        return Collections.emptyList();
    }

    public IVisualPart<? extends Node> getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent();
    }

    public void setContentBendPoints(List<IBendableContentPart.BendPoint> bendPoints) {
        if (this.getContent() instanceof ProxyAdaptedConnection) {
            ProxyAdaptedConnection proxy = (ProxyAdaptedConnection)this.getContent();
            proxy.setBendPoints(bendPoints);
            this.parent = this.getParent();
            return;
        }
        if (bendPoints.size() >= 2) {
            IBendableContentPart.BendPoint start = bendPoints.get(0);
            IBendableContentPart.BendPoint end = bendPoints.get(bendPoints.size() - 1);
            AdaptedConnector startConnector = (AdaptedConnector)start.getContentAnchorage();
            AdaptedConnector endConnector = (AdaptedConnector)end.getContentAnchorage();
            if (startConnector == this.sourceConnector && endConnector == this.targetConnector) {
                return;
            }
            this.parent = this.getParent();
            ((AdaptedConnection)this.getContent()).remove();
            if (start.isAttached() && end.isAttached()) {
                startConnector.getParentAdaptedConnectable().createConnection(endConnector.getParentAdaptedConnectable(), AdaptedConnectorRole.SOURCE);
            }
        }
    }
}

