/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.layout.Region;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedConnectorRole;
import net.officefloor.eclipse.editor.AdaptedPotentialConnection;
import net.officefloor.eclipse.editor.internal.models.ActiveConnectionSourceModel;
import net.officefloor.eclipse.editor.internal.models.AdaptedConnectorImpl;
import net.officefloor.eclipse.editor.internal.parts.AbstractAdaptedConnectablePart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectablePart;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class AdaptedConnectorPart<R extends Region>
extends AbstractContentPart<R>
implements AdaptedConnectablePart {
    @Inject
    private ActiveConnectionSourceModel activeConnectionSource;

    @Override
    public AdaptedConnector<?> getContent() {
        return (AdaptedConnector)super.getContent();
    }

    @Override
    public void setActiveConnector(boolean isActive) {
        if (isActive) {
            this.activeConnectionSource.setActiveSource(this.getContent().getParentAdaptedConnectable(), this.getContent().getAssociationRole());
        } else {
            this.activeConnectionSource.setActiveSource(null, null);
        }
    }

    public void setContent(Object content) {
        if (content != null && !(content instanceof AdaptedConnectorImpl)) {
            throw new IllegalArgumentException("Only " + AdaptedConnectorImpl.class.getSimpleName() + " supported.");
        }
        super.setContent(content);
        this.activeConnectionSource.activeSource().addListener(change -> {
            ActiveConnectionSourceModel.ActiveConnectionSource activeSource = (ActiveConnectionSourceModel.ActiveConnectionSource)this.activeConnectionSource.activeSource().get();
            if (activeSource == null) {
                ((Region)this.getVisual()).visibleProperty().set(true);
                return;
            }
            if (this.getContent() == null) {
                return;
            }
            if (activeSource.getSource() == this.getContent().getParentAdaptedConnectable()) {
                return;
            }
            boolean isAbleToConnect = false;
            AdaptedPotentialConnection potentialConnection = activeSource.getSource().getPotentialConnection(this.getContent().getParentAdaptedConnectable());
            if (potentialConnection != null && potentialConnection.canCreateConnection()) {
                isAbleToConnect = true;
                AdaptedConnectorRole activeRole = activeSource.getRole();
                if (potentialConnection.getSourceModelClass() == potentialConnection.getTargetModelClass() && activeRole != null && activeRole.equals((Object)this.getContent().getAssociationRole())) {
                    isAbleToConnect = false;
                }
            }
            ((Region)this.getVisual()).visibleProperty().set(isAbleToConnect);
        });
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    protected R doCreateVisual() {
        AbstractAdaptedConnectablePart parent = (AbstractAdaptedConnectablePart)this.getParent();
        Region node = parent.getAdaptedConnectorNode((AdaptedConnector<?>)this.getContent());
        node.getStyleClass().add((Object)"connector");
        node.getStyleClass().add((Object)this.getContent().getConnectionModelClass().getSimpleName());
        node.getStyleClass().add((Object)(this.getContent().isAssociationCreateConnection() ? "connector-create" : "connector-not-create"));
        return (R)node;
    }

    protected void doRefreshVisual(Region visual) {
    }

    protected void unregisterFromVisualPartMap(IViewer viewer, Region visual) {
        Map registry = viewer.getVisualPartMap();
        if (registry.get(visual) == this) {
            registry.remove(visual);
        }
    }
}

