/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import net.officefloor.eclipse.editor.AdaptedActionVisualFactory;
import net.officefloor.eclipse.editor.AdaptedActionVisualFactoryContext;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedConnectorRole;
import net.officefloor.eclipse.editor.AdaptedConnectorVisualFactory;
import net.officefloor.eclipse.editor.AdaptedConnectorVisualFactoryContext;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultImages;
import net.officefloor.eclipse.editor.ModelAction;
import net.officefloor.model.Model;
import org.eclipse.gef.fx.nodes.GeometryNode;

public class AdaptedModelVisualFactoryContextImpl<M extends Model>
implements AdaptedModelVisualFactoryContext<M>,
AdaptedActionVisualFactoryContext {
    protected final Class<M> modelClass;
    protected final boolean isPalettePrototype;
    private final ConnectorLoader<M> connectorLoader;
    private final Actioner<M> actioner;

    public AdaptedModelVisualFactoryContextImpl(Class<M> modelClass, boolean isPalettePrototype, ConnectorLoader<M> connectorLoader, Actioner<M> actioner) {
        this.modelClass = modelClass;
        this.isPalettePrototype = isPalettePrototype;
        this.connectorLoader = connectorLoader;
        this.actioner = actioner;
    }

    @Override
    public <N extends Node> N addNode(Pane parent, N node) {
        parent.getChildren().add(node);
        return node;
    }

    @Override
    public <N extends Region> AdaptedModelVisualFactoryContext.Connector connector(final AdaptedConnectorVisualFactory<N> visualFactory, final Class ... connectionModelClasses) {
        return new AdaptedModelVisualFactoryContext.Connector(){
            private boolean isInitialised = false;
            private AdaptedConnectorRole role = null;
            private Class<?>[] roleConnectionClasses = null;
            private Region geometryNode = null;

            @Override
            public AdaptedModelVisualFactoryContext.Connector source(Class ... sourceConnectionClass) {
                if (this.isInitialised) {
                    throw new IllegalStateException("Connector already initialised for model " + AdaptedModelVisualFactoryContextImpl.this.modelClass.getName());
                }
                if (this.role != null) {
                    throw new IllegalStateException("Connector already initialised to target for model " + AdaptedModelVisualFactoryContextImpl.this.modelClass.getName());
                }
                this.role = AdaptedConnectorRole.SOURCE;
                this.roleConnectionClasses = sourceConnectionClass;
                return this;
            }

            @Override
            public AdaptedModelVisualFactoryContext.Connector target(Class ... targetConnectionClass) {
                if (this.isInitialised) {
                    throw new IllegalStateException("Connector already initialised for model " + AdaptedModelVisualFactoryContextImpl.this.modelClass.getName());
                }
                if (this.role != null) {
                    throw new IllegalStateException("Connector already initialised to source for model " + AdaptedModelVisualFactoryContextImpl.this.modelClass.getName());
                }
                this.role = AdaptedConnectorRole.TARGET;
                this.roleConnectionClasses = targetConnectionClass;
                return this;
            }

            @Override
            public Node getNode() {
                if (this.isInitialised) {
                    return this.geometryNode;
                }
                Object node = visualFactory.createGeometryNode(new AdaptedConnectorVisualFactoryContext(){});
                if (!(node instanceof GeometryNode)) {
                    throw new IllegalStateException("Connector visual must implement " + GeometryNode.class.getName() + " for model " + AdaptedModelVisualFactoryContextImpl.this.modelClass.getName());
                }
                this.geometryNode = node;
                ArrayList assocations = new ArrayList(connectionModelClasses.length);
                AdaptedModelVisualFactoryContextImpl.this.connectorLoader.loadConnectors(connectionModelClasses, null, assocations, this.geometryNode);
                if (this.roleConnectionClasses != null) {
                    AdaptedModelVisualFactoryContextImpl.this.connectorLoader.loadConnectors(this.roleConnectionClasses, this.role, assocations, this.geometryNode);
                }
                if (AdaptedModelVisualFactoryContextImpl.this.isPalettePrototype) {
                    return new Pane();
                }
                return this.geometryNode;
            }
        };
    }

    @Override
    public Node createImageWithHover(Class<?> resourceClass, String imageFilePath, String hoverImageFilePath) {
        return DefaultImages.createImageWithHover(resourceClass, imageFilePath, hoverImageFilePath);
    }

    @Override
    public <R extends Model, O> void action(ModelAction<R, O, M> action) {
        this.actioner.action(action);
    }

    @Override
    public <R extends Model, O> Node action(ModelAction<R, O, M> action, AdaptedActionVisualFactory visualFactory) {
        if (this.isPalettePrototype) {
            return new Pane();
        }
        Node node = visualFactory.createVisual(this);
        node.setOnMouseClicked(event -> this.action(action));
        node.getStyleClass().add((Object)"action");
        return node;
    }

    public static interface Actioner<M extends Model> {
        public void action(ModelAction<?, ?, M> var1);
    }

    public static interface ConnectorLoader<M extends Model> {
        public void loadConnectors(Class<?>[] var1, AdaptedConnectorRole var2, List<AdaptedConnector<M>> var3, Region var4);
    }
}

