/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import javafx.geometry.Orientation;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import net.officefloor.eclipse.common.javafx.resize.DragResizer;
import net.officefloor.eclipse.editor.OverlayVisualContext;
import net.officefloor.eclipse.editor.OverlayVisualFactory;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.parts.AbstractHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class AdaptedOverlayHandlePart
extends AbstractHandlePart<Pane>
implements OverlayVisualContext {
    private final Point location;
    private final OverlayVisualFactory visualFactory;
    private final Pane overlayParent = new Pane();
    private boolean isFixedWidth = false;
    private boolean isFixedHeight = false;

    public AdaptedOverlayHandlePart(Point location, OverlayVisualFactory visualFactory) {
        this.location = location;
        this.visualFactory = visualFactory;
    }

    protected Pane doCreateVisual() {
        this.visualFactory.loadOverlay(this);
        this.overlayParent.setLayoutX(this.location.x);
        this.overlayParent.setLayoutY(this.location.y);
        if (!this.isFixedWidth) {
            DragResizer.makeResizable((Region)this.overlayParent, (Orientation)Orientation.HORIZONTAL);
        }
        if (!this.isFixedHeight) {
            DragResizer.makeResizable((Region)this.overlayParent, (Orientation)Orientation.VERTICAL);
        }
        return this.overlayParent;
    }

    protected void doRefreshVisual(Pane visual) {
    }

    @Override
    public Pane getOverlayParent() {
        return this.overlayParent;
    }

    @Override
    public void setFixedWidth(boolean isFixedWith) {
        this.isFixedWidth = isFixedWith;
    }

    @Override
    public void setFixedHeight(boolean isFixedHeight) {
        this.isFixedHeight = isFixedHeight;
    }

    @Override
    public void close() {
        this.getRoot().removeChild((IVisualPart)this);
    }
}

