/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import net.officefloor.eclipse.editor.AdaptedParent;
import net.officefloor.eclipse.editor.internal.parts.AdaptedChildPart;
import net.officefloor.eclipse.editor.internal.parts.TransformContent;
import net.officefloor.model.Model;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;

public class AdaptedParentPart<M extends Model>
extends AdaptedChildPart<M, AdaptedParent<M>>
implements ITransformableContentPart<Node> {
    private TransformContent<M, AdaptedParent<M>> transformableContent;

    public static void loadStyling(Node visualNode) {
        visualNode.getStyleClass().remove((Object)"child");
        visualNode.getStyleClass().add((Object)"parent");
    }

    @Override
    public void init() {
        super.init();
        this.transformableContent = new TransformContent(this);
    }

    public <T> T getAdapter(Class<T> classKey) {
        T adapter = ((AdaptedParent)this.getContent()).getAdapter(classKey);
        if (adapter != null) {
            return adapter;
        }
        return (T)super.getAdapter(classKey);
    }

    @Override
    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    @Override
    public Node doCreateVisual() {
        if (((AdaptedParent)this.getContent()).isPalettePrototype()) {
            this.isPalettePrototype = true;
        }
        Node container = super.doCreateVisual();
        AdaptedParentPart.loadStyling(container);
        Object model = ((AdaptedParent)this.getContent()).getModel();
        container.setLayoutX((double)model.getX());
        container.setLayoutY((double)model.getY());
        return container;
    }

    public Affine getContentTransform() {
        return this.transformableContent.getContentTransform();
    }

    public void setContentTransform(Affine totalTransform) {
        this.transformableContent.setContentTransform(totalTransform);
    }
}

